/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::Parameters"
  Parameters::Parameters (uint32_t            size_store_queue       ,
			  uint32_t            size_load_queue        ,
			  uint32_t            size_speculative_access_queue,
			  uint32_t            nb_port_check          ,
			  Tspeculative_load_t speculative_load       ,
			  uint32_t            nb_context             ,
			  uint32_t            nb_front_end           ,
			  uint32_t            nb_ooo_engine          ,
			  uint32_t            nb_packet              ,
			  uint32_t            size_general_data      ,
			  uint32_t            nb_general_register    ):
    _size_store_queue        (size_store_queue       ),
    _size_load_queue         (size_load_queue        ),
    _size_speculative_access_queue (size_speculative_access_queue),
    _nb_port_check           (nb_port_check          ),
    _speculative_load        (speculative_load       ),
    _nb_context              (nb_context             ),
    _nb_front_end            (nb_front_end           ),
    _nb_ooo_engine           (nb_ooo_engine          ),
    _nb_packet               (nb_packet              ),
    _size_general_data       (size_general_data      ),
    _nb_general_register     (nb_general_register    ),
    
    _size_address_store_queue              (log2(size_store_queue             )),
    _size_address_load_queue               (log2(size_load_queue              )),
    _size_address_speculative_access_queue (log2(size_speculative_access_queue)),

    _size_context_id         (log2(nb_context         )),
    _size_front_end_id       (log2(nb_front_end       )),
    _size_ooo_engine_id      (log2(nb_ooo_engine      )),
    _size_packet_id          (log2(nb_packet          )),
    _size_general_register   (log2(nb_general_register)),
    _size_dcache_context_id  (_size_context_id + _size_front_end_id + _size_ooo_engine_id),
    _size_dcache_packet_id   ((log2((size_store_queue>size_load_queue)?size_store_queue:size_load_queue))+1),

    _have_port_context_id        (_size_context_id   >0),
    _have_port_front_end_id      (_size_front_end_id >0),
    _have_port_ooo_engine_id     (_size_ooo_engine_id>0),
    _have_port_packet_id         (_size_packet_id    >0),
    _have_port_dcache_context_id (_size_dcache_context_id>0),

    _mask_address_lsb            (gen_mask<Tdcache_address_t>(log2(size_general_data/8))),
    _mask_address_msb            (gen_mask<Tdcache_address_t>(size_general_data) << log2(size_general_data/8))
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");
    test();
    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Load_store_unit::Parameters (copy)"
  Parameters::Parameters (Parameters & param):
    _size_store_queue        (param._size_store_queue       ),
    _size_load_queue         (param._size_load_queue        ),
    _size_speculative_access_queue (param._size_speculative_access_queue),
    _nb_port_check           (param._nb_port_check          ),
    _speculative_load        (param._speculative_load       ),
    _nb_context              (param._nb_context             ),
    _nb_front_end            (param._nb_front_end           ),
    _nb_ooo_engine           (param._nb_ooo_engine          ),
    _nb_packet               (param._nb_packet              ),
    _size_general_data       (param._size_general_data      ),
    _nb_general_register     (param._nb_general_register    ),

    _size_address_store_queue              (param._size_address_store_queue             ),
    _size_address_load_queue               (param._size_address_load_queue              ),
    _size_address_speculative_access_queue (param._size_address_speculative_access_queue),

    _size_context_id         (param._size_context_id        ),
    _size_front_end_id       (param._size_front_end_id      ),
    _size_ooo_engine_id      (param._size_ooo_engine_id     ),
    _size_packet_id          (param._size_packet_id         ),
    _size_general_register   (param._size_general_register  ),
    _size_dcache_context_id  (param._size_dcache_context_id ),
    _size_dcache_packet_id   (param._size_dcache_packet_id  ),

    _have_port_context_id    (param._have_port_context_id   ),
    _have_port_front_end_id  (param._have_port_front_end_id ),
    _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
    _have_port_packet_id     (param._have_port_packet_id    ),

    _have_port_dcache_context_id(param._have_port_dcache_context_id),

    _mask_address_lsb        (param._mask_address_lsb),
    _mask_address_msb        (param._mask_address_msb)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");
    test();
    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Load_store_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");
    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
