#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_network_read_unit_to_execution_unit_Types_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_network_read_unit_to_execution_unit_Types_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Common/include/ToString.h"
#include "Common/include/FromString.h"
#include "Common/include/ErrorMorpheo.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {

  typedef enum
    {
      PRIORITY_STATIC,
      PRIORITY_ROUND_ROBIN
    } Tpriority_t;

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Tpriority_t>(const morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Tpriority_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::PRIORITY_STATIC      : return "priority_static"; break;
      case morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::PRIORITY_ROUND_ROBIN : return "priority_round_robin"; break;
      default    : return ""      ; break;
      }
  };

  template<> inline morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Tpriority_t fromString<morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Tpriority_t>(const std::string& x)
  {
    if ( (x.compare("0")                    == 0) or
         (x.compare("priority_static")      == 0))
      return morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::PRIORITY_STATIC;
    if ( (x.compare("1")                    == 0) or
         (x.compare("priority_round_robin") == 0))
      return morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::PRIORITY_ROUND_ROBIN;
    throw (ERRORMORPHEO ("fromString","Unknow string : \""+x+"\""));
  };


}; // end namespace morpheo              

#endif
