#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_load_store_pointer_unit_Load_Store_pointer_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_load_store_pointer_unit_Load_Store_pointer_unit_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Types.h"

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace load_store_pointer_unit {


  class Load_Store_pointer_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t     )      **  in_INSERT_VAL                  ; // [nb_inst_insert]
  public    : SC_OUT(Tcontrol_t     )      ** out_INSERT_ACK                  ; // [nb_inst_insert]
  public    : SC_IN (Tcontext_t     )      **  in_INSERT_FRONT_END_ID         ; // [nb_inst_insert]
  public    : SC_IN (Tcontext_t     )      **  in_INSERT_CONTEXT_ID           ; // [nb_inst_insert]
  public    : SC_IN (Ttype_t        )      **  in_INSERT_TYPE                 ; // [nb_inst_insert]
  public    : SC_IN (Toperation_t   )      **  in_INSERT_OPERATION            ; // [nb_inst_insert]
  public    : SC_OUT(Tlsq_ptr_t     )      ** out_INSERT_STORE_QUEUE_PTR_WRITE; // [nb_inst_insert]
  public    : SC_OUT(Tlsq_ptr_t     )      ** out_INSERT_LOAD_QUEUE_PTR_WRITE ; // [nb_inst_insert]

    // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t     )      **  in_RETIRE_VAL                  ; // [nb_inst_retire]
  public    : SC_OUT(Tcontrol_t     )      ** out_RETIRE_ACK                  ; // [nb_inst_retire]
  public    : SC_IN (Tcontext_t     )      **  in_RETIRE_FRONT_END_ID         ; // [nb_inst_retire]
  public    : SC_IN (Tcontext_t     )      **  in_RETIRE_CONTEXT_ID           ; // [nb_inst_retire]
  public    : SC_IN (Ttype_t        )      **  in_RETIRE_TYPE                 ; // [nb_inst_retire]
  public    : SC_IN (Toperation_t   )      **  in_RETIRE_OPERATION            ; // [nb_inst_retire]
  public    : SC_IN (Tlsq_ptr_t     )      **  in_RETIRE_STORE_QUEUE_PTR_WRITE; // [nb_inst_retire]
  public    : SC_IN (Tlsq_ptr_t     )      **  in_RETIRE_LOAD_QUEUE_PTR_WRITE ; // [nb_inst_retire]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  public    : Tlsq_ptr_t                     * reg_STORE_QUEUE_PTR_WRITE; // [nb_load_store_queue]
  public    : bool                          ** reg_STORE_QUEUE_USE      ; // [nb_load_store_queue][size_store_queue]
  public    : Tlsq_ptr_t                     * reg_STORE_QUEUE_NB_USE   ; // [nb_load_store_queue]
  public    : Tlsq_ptr_t                     * reg_LOAD_QUEUE_PTR_WRITE ; // [nb_load_store_queue]
  public    : bool                          ** reg_LOAD_QUEUE_USE       ; // [nb_load_store_queue][size_load_queue]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : Tcontrol_t                     * internal_INSERT_ACK          ; // [nb_inst_insert]
  public    : operation_use_t                * internal_INSERT_OPERATION_USE; // [nb_inst_insert]
  public    : uint32_t                       * internal_INSERT_LSQ          ; // [nb_inst_insert]
  public    : Tlsq_ptr_t                     * internal_INSERT_PTR          ; // [nb_inst_insert]

  public    : Tcontrol_t                     * internal_RETIRE_ACK          ; // [nb_inst_retire]
  public    : operation_use_t                * internal_RETIRE_OPERATION_USE; // [nb_inst_retire]
  public    : uint32_t                       * internal_RETIRE_LSQ          ; // [nb_inst_retire]
  public    : Tlsq_ptr_t                     * internal_RETIRE_PTR          ; // [nb_inst_retire]

#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Load_Store_pointer_unit);
#endif
  public  :          Load_Store_pointer_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Load_Store_pointer_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy_insert           (void);
  public  : void        genMealy_retire           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace load_store_pointer_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
