#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::genMealy_pop"
  void Free_List_unit::genMealy_pop (void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    for (uint32_t i=0; i<_param->_nb_pop; i++)
      {
	uint32_t offset = i*_param->_nb_bank_by_pop;

	// GPR
	bool gpr_ack = not PORT_READ(in_POP_GPR_VAL[i]);

	if (not gpr_ack)
	  for (uint32_t j=0; j<_param->_nb_bank_by_pop; j++)
	    {
	      uint32_t bank = offset+((j+internal_BANK_PRIORITY)%_param->_nb_bank_by_pop);
	      
	      if (not _gpr_list[bank].empty())
		{
		  // find
		  gpr_ack = true;
		  internal_POP_GPR_BANK [i] = bank;
		  PORT_WRITE(out_POP_GPR_NUM_REG [i],
			     //(bank << _param->_shift) |
			     _gpr_list[bank].front());
		  
		  break;
		}
	    }

	// SPR
	bool spr_ack = not PORT_READ(in_POP_SPR_VAL[i]);

	if (not spr_ack)
	  for (uint32_t j=0; j<_param->_nb_bank_by_pop; j++)
	    {
	      uint32_t bank = offset+((j+internal_BANK_PRIORITY)%_param->_nb_bank_by_pop);
	      
	      if (not _spr_list[bank].empty())
		{
		  // find
		  spr_ack = true;
		  internal_POP_SPR_BANK [i] = bank;
		  PORT_WRITE(out_POP_SPR_NUM_REG [i],
			     //(bank << _param->_shift) |
			     _spr_list[bank].front());
		  
		  break;
		}
	    }

	internal_POP_ACK [i] = gpr_ack and spr_ack;
	
	PORT_WRITE(out_POP_ACK [i], internal_POP_ACK [i]);
      }
    

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
