#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/include/Register_translation_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_translation_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_translation_unit_Glue::genMealy_insert"
  void Register_translation_unit_Glue::genMealy_insert (void)
  {
    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"Begin");

    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      {
	Tcontrol_t rename_val     = PORT_READ(in_INSERT_RENAME_VAL     [i]);
	Tcontrol_t insert_ack     = PORT_READ(in_INSERT_INSERT_ACK     [i]);
	Tcontrol_t rat_rename_ack = PORT_READ(in_INSERT_RAT_RENAME_ACK [i]);
	Tcontrol_t rat_insert_ack = PORT_READ(in_INSERT_RAT_INSERT_ACK [i]);
	Tcontrol_t free_list_ack  = PORT_READ(in_INSERT_FREE_LIST_ACK  [i]);
	Tcontrol_t stat_list_ack  = PORT_READ(in_INSERT_STAT_LIST_ACK  [i]);

	PORT_WRITE(out_INSERT_RENAME_ACK     [i], (insert_ack     and
						   rat_rename_ack and
						   rat_insert_ack and
						   free_list_ack  and
						   stat_list_ack  ));
	PORT_WRITE(out_INSERT_INSERT_VAL     [i], (rename_val     and
						   rat_rename_ack and
						   rat_insert_ack and
						   free_list_ack  and
						   stat_list_ack  ));
	PORT_WRITE(out_INSERT_RAT_INSERT_VAL [i], (rename_val     and
						   insert_ack     and
						   rat_rename_ack and
						   free_list_ack  and
						   stat_list_ack  ));
	PORT_WRITE(out_INSERT_FREE_LIST_VAL  [i], (rename_val     and
						   insert_ack     and
						   rat_rename_ack and
						   rat_insert_ack and
						   stat_list_ack  ));
	PORT_WRITE(out_INSERT_STAT_LIST_VAL  [i], (rename_val     and
						   insert_ack     and
						   rat_rename_ack and
						   rat_insert_ack and
						   free_list_ack  ));
      }

    log_printf(FUNC,Register_translation_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_translation_unit_glue
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
