/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Sort/SelfTest/include/test.h"

#define NB_PARAMS 6

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_input            (uint32_t)\n"));
  err (_(" * nb_output           (uint32_t)\n"));
  err (_(" * ascending           (bool    )\n"));
  err (_(" * size_data           (uint32_t)\n"));
  err (_(" * have_port_index_out (bool    )\n"));
  err (_(" * have_port_data_out  (bool    )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t _nb_input            = fromString<uint32_t>(argv[x++]);
  uint32_t _nb_output           = fromString<uint32_t>(argv[x++]);
  bool     _ascending           = fromString<bool    >(argv[x++]);
  uint32_t _size_data           = fromString<uint32_t>(argv[x++]);
  bool     _have_port_index_out = fromString<bool    >(argv[x++]);
  bool     _have_port_data_out  = fromString<bool    >(argv[x++]);

  int _return = EXIT_SUCCESS;

  try 
    {
      morpheo::behavioural::generic::sort::Parameters * param = new morpheo::behavioural::generic::sort::Parameters
	(_nb_input           ,
	 _nb_output          ,
	 _ascending          ,
	 _size_data          ,
	 _have_port_index_out,
	 _have_port_data_out );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
