#include "../include/Cache.h"

namespace environnement {
namespace cache {
  
  // Return the time to have the data
  // latence is call on the same port in a single cycle, only the last access is save
  // { NOTE } : type_cache = 0 : icache, 1 : dcache
  uint32_t Cache::latence (cache_t               type_cache, 
			   uint32_t              num_entity, 
			   uint32_t              num_port  , 
			   uint32_t              address   , 
			   uint32_t              trdid     , 
			   type_req_cache_t      type      ,
			   direction_req_cache_t dir    )
  {
    if (num_entity >= param->nb_cache_dedicated)
      {
	std::cerr << "<Cache.latence> {ERROR} num_entity must be >= nb_cache_dedicated" << std::endl;
	exit (1);
      }

    cache_multilevel::Cache_MultiLevel * cache;
    if (type_cache == INSTRUCTION_CACHE)
      cache = icache_dedicated [num_entity];
    else
      cache = dcache_dedicated [num_entity];

    if (num_port >= cache->param->nb_port)
      {
	std::cerr << "<Cache.latence> {ERROR} num_port can be >= nb_port" << std::endl;
	exit (1);
      }

    // Make a access with this level "dedicated"
    std::cout << "cache dedicated : access" << std::endl;
    cache_multilevel::Access access_dedicated = cache->access(num_port,address,trdid,type,dir);

    if (access_dedicated.hit == MISS)
      {
	std::cout << "cache shared    : access" << std::endl;
	// Make a access with this level "shared"
	cache_multilevel::Access access_shared  = cache_shared->access(range_port (type_cache,num_entity)+num_port,address,trdid,type,dir);
	
	cache_shared->update_access (access_shared);
	
	access_dedicated.last_nb_level = param->nb_cache_dedicated-1; // Update all cache
	access_dedicated.latence += access_shared.latence;
      }

    std::cout << "end access, update access" << std::endl;

    cache->update_access (access_dedicated);

    std::cout << "end access, update access" << std::endl;

    return access_dedicated.latence;
  }

};
};
