/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"

#define NB_ITERATION  1
#define CYCLE_MAX     (1024*NB_ITERATION)

#define LABEL(str...)							\
  {									\
    msg (_("{%d} "),static_cast<uint32_t>(sc_simulation_time()));	\
    msg (str);								\
    msg (_("\n"));							\
  } while(0)

#define SC_START(cycle_offset)                                                       \
  do									             \
    {									             \
      /*cout << "SC_START (begin)" << endl;*/				             \
									             \
      uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time());          \
      if (cycle_offset != 0)						             \
	{								             \
	  cout << "##########[ cycle "<< cycle_current+cycle_offset << " ]" << endl; \
	}								             \
									             \
      if (cycle_current > CYCLE_MAX)					             \
	{								             \
	  TEST_KO("Maximal cycles Reached");				             \
	}								             \
									             \
      sc_start(cycle_offset);						             \
									             \
      /*cout << "SC_START (end  )" << endl;*/				             \
    } while(0)

class execute_transaction
{
public : const Tcontext_t         _context_id   ;
public : const Tcontext_t         _front_end_id ;
public : const Tcontext_t         _ooo_engine_id;
public : const Tpacket_t          _packet_id    ;
public : const Toperation_t       _operation    ;
public : const Ttype_t            _type         ;
public : const Tcontrol_t         _has_immediat ;
public : const Tgeneral_data_t    _immediat     ;
public : const Tgeneral_data_t    _data_ra      ;
public : const Tgeneral_data_t    _data_rb      ;
public : const Tspecial_data_t    _data_rc      ;
public : const Tcontrol_t         _write_rd     ;
public : const Tgeneral_address_t _num_reg_rd   ;
public : const Tgeneral_data_t    _data_rd      ;
public : const Tcontrol_t         _write_re     ;
public : const Tspecial_address_t _num_reg_re   ;
public : const Tspecial_data_t    _data_re      ;
public : const Texception_t       _exception    ;
public : const Tcontrol_t         _no_sequence  ;
public : const Tgeneral_data_t    _address      ;

public : execute_transaction (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Parameters * param        ,
			      Tcontext_t         context_id   ,
			      Tcontext_t         front_end_id ,
			      Tcontext_t         ooo_engine_id,
			      Tpacket_t          packet_id    ,
			      Toperation_t       operation    ,
			      Ttype_t            type         ,
			      Tcontrol_t         has_immediat ,
			      Tgeneral_data_t    immediat     ,
			      Tgeneral_data_t    data_ra      ,
			      Tgeneral_data_t    data_rb      ,
			      Tspecial_data_t    data_rc      ,
			      Tcontrol_t         write_rd     ,
			      Tgeneral_address_t num_reg_rd   ,
			      Tgeneral_data_t    data_rd      ,
			      Tcontrol_t         write_re     ,
			      Tspecial_address_t num_reg_re   ,
			      Tspecial_data_t    data_re      ,
			      Texception_t       exception    ,
			      Tcontrol_t         no_sequence  ,
			      Tgeneral_data_t    address     =0):
  _context_id    (context_id   % param->_nb_context   ),
  _front_end_id  (front_end_id % param->_nb_front_end ),
  _ooo_engine_id (ooo_engine_id% param->_nb_ooo_engine),
  _packet_id     (packet_id    % param->_nb_packet    ),
  _operation     (operation    ),
  _type          (type         ),
  _has_immediat  (has_immediat ),
  _immediat      (immediat     & gen_mask<Tgeneral_data_t>(param->_size_general_data)),
  _data_ra       (data_ra      & gen_mask<Tgeneral_data_t>(param->_size_general_data)),
  _data_rb       (data_rb      & gen_mask<Tgeneral_data_t>(param->_size_general_data)),
  _data_rc       (data_rc      & gen_mask<Tspecial_data_t>(param->_size_special_data)),
  _write_rd      (write_rd     ),
  _num_reg_rd    (num_reg_rd   % param->_nb_special_register),
  _data_rd       (data_rd      & gen_mask<Tgeneral_data_t>(param->_size_general_data)),
  _write_re      (write_re     ),
  _num_reg_re    (num_reg_re   % param->_nb_special_register),
  _data_re       (data_re      & gen_mask<Tspecial_data_t>(param->_size_special_data)),
  _exception     (exception    ),
  _no_sequence   (no_sequence  ),
  _address       (address      & gen_mask<Tgeneral_data_t>(param->_size_general_data))
  {
    
  }
};

void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Functionnal_unit * _Functionnal_unit = new Functionnal_unit (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename = "";

  sc_clock              in_CLOCK  ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> in_NRESET ("nreset");

  sc_signal<Tcontrol_t        >  in_EXECUTE_IN_VAL            (rename.c_str());
  sc_signal<Tcontrol_t        > out_EXECUTE_IN_ACK            (rename.c_str());
  sc_signal<Tcontext_t        >  in_EXECUTE_IN_CONTEXT_ID     (rename.c_str());
  sc_signal<Tcontext_t        >  in_EXECUTE_IN_FRONT_END_ID   (rename.c_str());
  sc_signal<Tcontext_t        >  in_EXECUTE_IN_OOO_ENGINE_ID  (rename.c_str());
  sc_signal<Tpacket_t         >  in_EXECUTE_IN_PACKET_ID      (rename.c_str());
  sc_signal<Toperation_t      >  in_EXECUTE_IN_OPERATION      (rename.c_str());
  sc_signal<Ttype_t           >  in_EXECUTE_IN_TYPE           (rename.c_str());
  sc_signal<Tlsq_ptr_t        >  in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE (rename.c_str());
  sc_signal<Tlsq_ptr_t        >  in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE  (rename.c_str());
  sc_signal<Tcontrol_t        >  in_EXECUTE_IN_HAS_IMMEDIAT   (rename.c_str());
  sc_signal<Tgeneral_data_t   >  in_EXECUTE_IN_IMMEDIAT       (rename.c_str());
  sc_signal<Tgeneral_data_t   >  in_EXECUTE_IN_DATA_RA        (rename.c_str());
  sc_signal<Tgeneral_data_t   >  in_EXECUTE_IN_DATA_RB        (rename.c_str());
  sc_signal<Tspecial_data_t   >  in_EXECUTE_IN_DATA_RC        (rename.c_str());
  sc_signal<Tcontrol_t        >  in_EXECUTE_IN_WRITE_RD       (rename.c_str());
  sc_signal<Tgeneral_address_t>  in_EXECUTE_IN_NUM_REG_RD     (rename.c_str());
  sc_signal<Tcontrol_t        >  in_EXECUTE_IN_WRITE_RE       (rename.c_str());
  sc_signal<Tspecial_address_t>  in_EXECUTE_IN_NUM_REG_RE     (rename.c_str());

    // ~~~~~[ Interface "execute_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sc_signal<Tcontrol_t        > out_EXECUTE_OUT_VAL            (rename.c_str());
  sc_signal<Tcontrol_t        >  in_EXECUTE_OUT_ACK            (rename.c_str());
  sc_signal<Tcontext_t        > out_EXECUTE_OUT_CONTEXT_ID     (rename.c_str());
  sc_signal<Tcontext_t        > out_EXECUTE_OUT_FRONT_END_ID   (rename.c_str());
  sc_signal<Tcontext_t        > out_EXECUTE_OUT_OOO_ENGINE_ID  (rename.c_str());
  sc_signal<Tpacket_t         > out_EXECUTE_OUT_PACKET_ID      (rename.c_str());
//sc_signal<Toperation_t      > out_EXECUTE_OUT_OPERATION      (rename.c_str());
  sc_signal<Ttype_t           > out_EXECUTE_OUT_TYPE           (rename.c_str());
  sc_signal<Tcontrol_t        > out_EXECUTE_OUT_WRITE_RD       (rename.c_str());
  sc_signal<Tgeneral_address_t> out_EXECUTE_OUT_NUM_REG_RD     (rename.c_str());
  sc_signal<Tgeneral_data_t   > out_EXECUTE_OUT_DATA_RD        (rename.c_str());
  sc_signal<Tcontrol_t        > out_EXECUTE_OUT_WRITE_RE       (rename.c_str());
  sc_signal<Tspecial_address_t> out_EXECUTE_OUT_NUM_REG_RE     (rename.c_str());
  sc_signal<Tspecial_data_t   > out_EXECUTE_OUT_DATA_RE        (rename.c_str());
  sc_signal<Texception_t      > out_EXECUTE_OUT_EXCEPTION      (rename.c_str());
  sc_signal<Tcontrol_t        > out_EXECUTE_OUT_NO_SEQUENCE    (rename.c_str());
  sc_signal<Tgeneral_data_t   > out_EXECUTE_OUT_ADDRESS        (rename.c_str());
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Functionnal_unit.\n"),name.c_str());

  (*(_Functionnal_unit->in_CLOCK))        (in_CLOCK);
  (*(_Functionnal_unit->in_NRESET))       (in_NRESET);
  (*(_Functionnal_unit-> in_EXECUTE_IN_VAL           )) ( in_EXECUTE_IN_VAL           );
  (*(_Functionnal_unit->out_EXECUTE_IN_ACK           )) (out_EXECUTE_IN_ACK           );
  if (_param->_have_port_context_id)
  (*(_Functionnal_unit-> in_EXECUTE_IN_CONTEXT_ID    )) ( in_EXECUTE_IN_CONTEXT_ID    );
  if (_param->_have_port_front_end_id)
  (*(_Functionnal_unit-> in_EXECUTE_IN_FRONT_END_ID  )) ( in_EXECUTE_IN_FRONT_END_ID  );
  if (_param->_have_port_ooo_engine_id)
  (*(_Functionnal_unit-> in_EXECUTE_IN_OOO_ENGINE_ID )) ( in_EXECUTE_IN_OOO_ENGINE_ID );
  if (_param->_have_port_packet_id)
  (*(_Functionnal_unit-> in_EXECUTE_IN_PACKET_ID     )) ( in_EXECUTE_IN_PACKET_ID     );
  (*(_Functionnal_unit-> in_EXECUTE_IN_OPERATION     )) ( in_EXECUTE_IN_OPERATION     );
  (*(_Functionnal_unit-> in_EXECUTE_IN_TYPE          )) ( in_EXECUTE_IN_TYPE          );
  (*(_Functionnal_unit-> in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE)) ( in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE);
  if (_param->_have_port_load_queue_ptr)
  (*(_Functionnal_unit-> in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE )) ( in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE );
  (*(_Functionnal_unit-> in_EXECUTE_IN_HAS_IMMEDIAT  )) ( in_EXECUTE_IN_HAS_IMMEDIAT  );
  (*(_Functionnal_unit-> in_EXECUTE_IN_IMMEDIAT      )) ( in_EXECUTE_IN_IMMEDIAT      );
  (*(_Functionnal_unit-> in_EXECUTE_IN_DATA_RA       )) ( in_EXECUTE_IN_DATA_RA       );
  (*(_Functionnal_unit-> in_EXECUTE_IN_DATA_RB       )) ( in_EXECUTE_IN_DATA_RB       );
  (*(_Functionnal_unit-> in_EXECUTE_IN_DATA_RC       )) ( in_EXECUTE_IN_DATA_RC       );
  (*(_Functionnal_unit-> in_EXECUTE_IN_WRITE_RD      )) ( in_EXECUTE_IN_WRITE_RD      );
  (*(_Functionnal_unit-> in_EXECUTE_IN_NUM_REG_RD    )) ( in_EXECUTE_IN_NUM_REG_RD    );
  (*(_Functionnal_unit-> in_EXECUTE_IN_WRITE_RE      )) ( in_EXECUTE_IN_WRITE_RE      );
  (*(_Functionnal_unit-> in_EXECUTE_IN_NUM_REG_RE    )) ( in_EXECUTE_IN_NUM_REG_RE    );
  
  (*(_Functionnal_unit->out_EXECUTE_OUT_VAL          )) (out_EXECUTE_OUT_VAL          );
  (*(_Functionnal_unit-> in_EXECUTE_OUT_ACK          )) ( in_EXECUTE_OUT_ACK          );
  if (_param->_have_port_context_id)
  (*(_Functionnal_unit->out_EXECUTE_OUT_CONTEXT_ID   )) (out_EXECUTE_OUT_CONTEXT_ID   );
  if (_param->_have_port_front_end_id)
  (*(_Functionnal_unit->out_EXECUTE_OUT_FRONT_END_ID )) (out_EXECUTE_OUT_FRONT_END_ID );
  if (_param->_have_port_ooo_engine_id)
  (*(_Functionnal_unit->out_EXECUTE_OUT_OOO_ENGINE_ID)) (out_EXECUTE_OUT_OOO_ENGINE_ID);
  if (_param->_have_port_packet_id)
  (*(_Functionnal_unit->out_EXECUTE_OUT_PACKET_ID    )) (out_EXECUTE_OUT_PACKET_ID    );
//(*(_Functionnal_unit->out_EXECUTE_OUT_OPERATION    )) (out_EXECUTE_OUT_OPERATION    );
  (*(_Functionnal_unit->out_EXECUTE_OUT_TYPE         )) (out_EXECUTE_OUT_TYPE         );
  (*(_Functionnal_unit->out_EXECUTE_OUT_WRITE_RD     )) (out_EXECUTE_OUT_WRITE_RD     );
  (*(_Functionnal_unit->out_EXECUTE_OUT_NUM_REG_RD   )) (out_EXECUTE_OUT_NUM_REG_RD   );
  (*(_Functionnal_unit->out_EXECUTE_OUT_DATA_RD      )) (out_EXECUTE_OUT_DATA_RD      );
  (*(_Functionnal_unit->out_EXECUTE_OUT_WRITE_RE     )) (out_EXECUTE_OUT_WRITE_RE     );
  (*(_Functionnal_unit->out_EXECUTE_OUT_NUM_REG_RE   )) (out_EXECUTE_OUT_NUM_REG_RE   );
  (*(_Functionnal_unit->out_EXECUTE_OUT_DATA_RE      )) (out_EXECUTE_OUT_DATA_RE      );
  (*(_Functionnal_unit->out_EXECUTE_OUT_EXCEPTION    )) (out_EXECUTE_OUT_EXCEPTION    );
  (*(_Functionnal_unit->out_EXECUTE_OUT_NO_SEQUENCE  )) (out_EXECUTE_OUT_NO_SEQUENCE  );
  (*(_Functionnal_unit->out_EXECUTE_OUT_ADDRESS      )) (out_EXECUTE_OUT_ADDRESS      );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const  int32_t percent_transaction_execute_in  = 75;
  const  int32_t percent_transaction_execute_out = 75;

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  list<execute_transaction> transaction_in;
  list<execute_transaction> transaction_out;
  int32_t nb_transaction_out;


  SC_START(0);
  LABEL("Initialisation");
  
  transaction_in.push_back(execute_transaction(_param,0,0,0,  0,OPERATION_ALU_L_ADD     ,TYPE_ALU,0,0xdeadbeef,0x12344321,0x12345678,0              ,1,63,0x24689999,1,15,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,  1,OPERATION_ALU_L_ADD     ,TYPE_ALU,0,0xffffffff,0x12345678,0x12345678,0              ,1,56,0x2468acf0,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,  2,OPERATION_ALU_L_ADD     ,TYPE_ALU,1,0x12345678,0x12345678,0xffffffff,0              ,1,56,0x2468acf0,1,3 ,0              ,EXCEPTION_NONE     ,0));
  // Test L_ADD flags					     			       
  transaction_in.push_back(execute_transaction(_param,0,0,0,  3,OPERATION_ALU_L_ADD     ,TYPE_ALU,1,0x0       ,0x0       ,0x0       ,0              ,1,56,0x0       ,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,  4,OPERATION_ALU_L_ADD     ,TYPE_ALU,1,0x90000000,0x70000000,0x0       ,0              ,1,56,0x0       ,1,3 ,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,  5,OPERATION_ALU_L_ADD     ,TYPE_ALU,1,0x80000000,0x80001000,0x0       ,0              ,1,1 ,0x1000    ,1,0 ,FLAG_CY|FLAG_OV,EXCEPTION_ALU_RANGE,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,  6,OPERATION_ALU_L_ADD     ,TYPE_ALU,1,0x7fffffff,0x00000001,0x0       ,FLAG_CY|FLAG_OV,1,1 ,0x80000000,1,0 ,        FLAG_OV,EXCEPTION_ALU_RANGE,0));
							     			       
							     			       
  transaction_in.push_back(execute_transaction(_param,0,0,0,  7,OPERATION_ALU_L_ADDC    ,TYPE_ALU,0,0xdeadbeef,0x12344321,0x12345678,0              ,1,63,0x24689999,1,15,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,  8,OPERATION_ALU_L_ADDC    ,TYPE_ALU,0,0xffffffff,0x12345678,0x12345678,0              ,1,56,0x2468acf0,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,  9,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x12345678,0x12345678,0xffffffff,0              ,1,56,0x2468acf0,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 10,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x0       ,0x0       ,0x0       ,0              ,1,56,0x0       ,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 11,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x90000000,0x70000000,0x0       ,0              ,1,56,0x0       ,1,3 ,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 12,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x80000000,0x80001000,0x0       ,0              ,1,1 ,0x1000    ,1,0 ,FLAG_CY|FLAG_OV,EXCEPTION_ALU_RANGE,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 13,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x7fffffff,0x00000001,0x0       ,0              ,1,1 ,0x80000000,1,0 ,        FLAG_OV,EXCEPTION_ALU_RANGE,0));
							     			       
  transaction_in.push_back(execute_transaction(_param,0,0,0, 14,OPERATION_ALU_L_ADDC    ,TYPE_ALU,0,0xdeadbeef,0x12344320,0x12345678,FLAG_CY        ,1,63,0x24689999,1,15,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 15,OPERATION_ALU_L_ADDC    ,TYPE_ALU,0,0xffffffff,0x12345677,0x12345678,FLAG_CY        ,1,56,0x2468acf0,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 16,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x12345678,0x12345677,0xffffffff,FLAG_CY        ,1,56,0x2468acf0,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 17,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x0       ,0x0       ,0x0       ,FLAG_CY        ,1,56,0x00000001,1,3 ,0              ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 18,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x90000000,0x70000003,0x0       ,FLAG_CY        ,1,56,0x00000004,1,3 ,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 19,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x80000000,0x8000000f,0x0       ,FLAG_CY        ,1,1 ,0x00000010,1,0 ,FLAG_CY|FLAG_OV,EXCEPTION_ALU_RANGE,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 20,OPERATION_ALU_L_ADDC    ,TYPE_ALU,1,0x7fffffff,0x00000000,0x0       ,FLAG_CY        ,1,1 ,0x80000000,1,0 ,        FLAG_OV,EXCEPTION_ALU_RANGE,0));
							     			       
  							     			       
  transaction_in.push_back(execute_transaction(_param,0,0,0, 21,OPERATION_ALU_L_AND     ,TYPE_ALU,0,0xdeadbeef,0x0000ffff,0x00ff00ff,0              ,1,63,0x000000ff,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 22,OPERATION_ALU_L_OR      ,TYPE_ALU,0,0xdeadbeef,0x0000ffff,0x00ff00ff,0              ,1,63,0x00ffffff,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 23,OPERATION_ALU_L_XOR     ,TYPE_ALU,0,0xdeadbeef,0x0000ffff,0x00ff00ff,0              ,1,63,0x00ffff00,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
							     			       
  transaction_in.push_back(execute_transaction(_param,0,0,0, 24,OPERATION_MOVE_L_CMOV    ,TYPE_MOVE,0,0x0       ,0xdeadbeef,0x12345678,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 25,OPERATION_MOVE_L_CMOV    ,TYPE_MOVE,0,0x0       ,0xdeadbeef,0x12345678,FLAG_F         ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 26,OPERATION_MOVE_L_MOVHI   ,TYPE_MOVE,1,0xdeadbeef,0x0       ,0x0       ,FLAG_F         ,1,63,0xbeef0000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
							     			       
							     			       
  transaction_in.push_back(execute_transaction(_param,0,0,0, 27,OPERATION_BRANCH_L_TEST_F  ,TYPE_BRANCH,1,0xdeadbeef,0x0       ,0x0       ,0              ,0,63,0xbeef0000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0,0x00000000));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 28,OPERATION_BRANCH_L_TEST_F  ,TYPE_BRANCH,1,0xdeadbeef,0x0       ,0x0       ,FLAG_F         ,0,63,0xbeef0000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,1,0xdeadbeef));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 29,OPERATION_BRANCH_L_TEST_NF ,TYPE_BRANCH,1,0xdeadbeef,0x0       ,0x0       ,FLAG_F         ,0,63,0xbeef0000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0,0x00000000));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 30,OPERATION_BRANCH_L_TEST_NF ,TYPE_BRANCH,1,0xdeadbeef,0x0       ,0x0       ,0              ,0,63,0xbeef0000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,1,0xdeadbeef));
							     			       
  							     			       
  transaction_in.push_back(execute_transaction(_param,0,0,0, 31,OPERATION_BRANCH_L_JALR    ,TYPE_BRANCH,0,0xdeadbeef,0x0       ,0x12345678,0              ,0,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,1,0x12345678)); // jr
  transaction_in.push_back(execute_transaction(_param,0,0,0, 32,OPERATION_BRANCH_L_JALR    ,TYPE_BRANCH,1,0xdeadbeef,0x0       ,0x12345678,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,1,0x12345678)); // jal
  transaction_in.push_back(execute_transaction(_param,0,0,0, 33,OPERATION_BRANCH_L_JALR    ,TYPE_BRANCH,1,0xdeadbeef,0x0       ,0x12345678,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,1,0x12345678)); // jalr
							     
  transaction_in.push_back(execute_transaction(_param,0,0,0, 34,OPERATION_EXTEND_L_EXTEND_S,TYPE_EXTEND,1,8         ,0x12345678,0x0       ,0              ,1,63,0x00000078,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 35,OPERATION_EXTEND_L_EXTEND_S,TYPE_EXTEND,1,16        ,0x12345678,0x0       ,0              ,1,63,0x00005678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 36,OPERATION_EXTEND_L_EXTEND_S,TYPE_EXTEND,1,32        ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 34,OPERATION_EXTEND_L_EXTEND_S,TYPE_EXTEND,1,8         ,0xdeadbeef,0x0       ,0              ,1,63,0xffffffef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 35,OPERATION_EXTEND_L_EXTEND_S,TYPE_EXTEND,1,16        ,0xdeadbeef,0x0       ,0              ,1,63,0xffffbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 36,OPERATION_EXTEND_L_EXTEND_S,TYPE_EXTEND,1,32        ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
							     
  transaction_in.push_back(execute_transaction(_param,0,0,0, 37,OPERATION_EXTEND_L_EXTEND_Z,TYPE_EXTEND,1,8         ,0x12345678,0x0       ,0              ,1,63,0x00000078,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 38,OPERATION_EXTEND_L_EXTEND_Z,TYPE_EXTEND,1,16        ,0x12345678,0x0       ,0              ,1,63,0x00005678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 39,OPERATION_EXTEND_L_EXTEND_Z,TYPE_EXTEND,1,32        ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 40,OPERATION_EXTEND_L_EXTEND_Z,TYPE_EXTEND,1,8         ,0xdeadbeef,0x0       ,0              ,1,63,0x000000ef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 41,OPERATION_EXTEND_L_EXTEND_Z,TYPE_EXTEND,1,16        ,0xdeadbeef,0x0       ,0              ,1,63,0x0000beef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 42,OPERATION_EXTEND_L_EXTEND_Z,TYPE_EXTEND,1,32        ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
							     
  transaction_in.push_back(execute_transaction(_param,0,0,0, 43,OPERATION_SHIFT_L_SLL     ,TYPE_SHIFT,1,0         ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 44,OPERATION_SHIFT_L_SLL     ,TYPE_SHIFT,1,4         ,0xdeadbeef,0x0       ,0              ,1,63,0xeadbeef0,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 45,OPERATION_SHIFT_L_SLL     ,TYPE_SHIFT,1,8         ,0xdeadbeef,0x0       ,0              ,1,63,0xadbeef00,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 46,OPERATION_SHIFT_L_SLL     ,TYPE_SHIFT,1,16        ,0xdeadbeef,0x0       ,0              ,1,63,0xbeef0000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 47,OPERATION_SHIFT_L_SLL     ,TYPE_SHIFT,1,24        ,0xdeadbeef,0x0       ,0              ,1,63,0xef000000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 48,OPERATION_SHIFT_L_SLL     ,TYPE_SHIFT,1,31        ,0xdeadbeef,0x0       ,0              ,1,63,0x80000000,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 49,OPERATION_SHIFT_L_SLL     ,TYPE_SHIFT,1,32        ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 50,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,0         ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 51,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,4         ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbee ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 52,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,8         ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbe  ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 53,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,16        ,0xdeadbeef,0x0       ,0              ,1,63,0xdead    ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 54,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,24        ,0xdeadbeef,0x0       ,0              ,1,63,0xde      ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 55,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,31        ,0xdeadbeef,0x0       ,0              ,1,63,0x1       ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 56,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,32        ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 57,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,0         ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 58,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,4         ,0x12345678,0x0       ,0              ,1,63,0x1234567 ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 59,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,8         ,0x12345678,0x0       ,0              ,1,63,0x123456  ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 60,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,16        ,0x12345678,0x0       ,0              ,1,63,0x1234    ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 61,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,24        ,0x12345678,0x0       ,0              ,1,63,0x12      ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 62,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,31        ,0x12345678,0x0       ,0              ,1,63,0x0       ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 63,OPERATION_SHIFT_L_SRL     ,TYPE_SHIFT,1,32        ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 64,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,0         ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 65,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,4         ,0xdeadbeef,0x0       ,0              ,1,63,0xfdeadbee,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 66,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,8         ,0xdeadbeef,0x0       ,0              ,1,63,0xffdeadbe,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 67,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,16        ,0xdeadbeef,0x0       ,0              ,1,63,0xffffdead,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 68,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,24        ,0xdeadbeef,0x0       ,0              ,1,63,0xffffffde,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 69,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,31        ,0xdeadbeef,0x0       ,0              ,1,63,0xffffffff,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 70,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,32        ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 71,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,0         ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 72,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,4         ,0x12345678,0x0       ,0              ,1,63,0x1234567 ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 73,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,8         ,0x12345678,0x0       ,0              ,1,63,0x123456  ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 74,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,16        ,0x12345678,0x0       ,0              ,1,63,0x1234    ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 75,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,24        ,0x12345678,0x0       ,0              ,1,63,0x12      ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 76,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,31        ,0x12345678,0x0       ,0              ,1,63,0x0       ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 77,OPERATION_SHIFT_L_SRA     ,TYPE_SHIFT,1,32        ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 78,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,0         ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 79,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,4         ,0xdeadbeef,0x0       ,0              ,1,63,0xfdeadbee,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 80,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,8         ,0xdeadbeef,0x0       ,0              ,1,63,0xefdeadbe,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 81,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,16        ,0xdeadbeef,0x0       ,0              ,1,63,0xbeefdead,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 82,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,24        ,0xdeadbeef,0x0       ,0              ,1,63,0xadbeefde,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 83,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,32        ,0xdeadbeef,0x0       ,0              ,1,63,0xdeadbeef,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 84,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,0         ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 85,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,4         ,0x12345678,0x0       ,0              ,1,63,0x81234567,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 86,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,8         ,0x12345678,0x0       ,0              ,1,63,0x78123456,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 87,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,16        ,0x12345678,0x0       ,0              ,1,63,0x56781234,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 88,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,24        ,0x12345678,0x0       ,0              ,1,63,0x34567812,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 89,OPERATION_SHIFT_L_ROR     ,TYPE_SHIFT,1,32        ,0x12345678,0x0       ,0              ,1,63,0x12345678,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
							     
  transaction_in.push_back(execute_transaction(_param,0,0,0, 90,OPERATION_FIND_L_FF1     ,TYPE_FIND,0,0         ,0x12345678,0x0       ,0              ,1,63,4         ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 91,OPERATION_FIND_L_FF1     ,TYPE_FIND,0,0         ,0x0       ,0x0       ,0              ,1,63,0          ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 92,OPERATION_FIND_L_FF1     ,TYPE_FIND,0,0         ,0x43210000,0x0       ,0              ,1,63,17         ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 93,OPERATION_FIND_L_FF1     ,TYPE_FIND,0,0         ,0x80000000,0x0       ,0              ,1,63,32         ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 94,OPERATION_FIND_L_FF1     ,TYPE_FIND,0,0         ,0x1       ,0x0       ,0              ,1,63,1          ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 95,OPERATION_FIND_L_FL1     ,TYPE_FIND,0,0         ,0x12345678,0x0       ,0              ,1,63,29        ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 96,OPERATION_FIND_L_FL1     ,TYPE_FIND,0,0         ,0x0       ,0x0       ,0              ,1,63,0          ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 97,OPERATION_FIND_L_FL1     ,TYPE_FIND,0,0         ,0x00018765,0x0       ,0              ,1,63,17         ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 98,OPERATION_FIND_L_FL1     ,TYPE_FIND,0,0         ,0x1       ,0x0       ,0              ,1,63,1          ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0, 99,OPERATION_FIND_L_FL1     ,TYPE_FIND,0,0         ,0x80000000,0x0       ,0              ,1,63,32         ,0,15,FLAG_CY        ,EXCEPTION_NONE     ,0));

//   transaction_in.push_back(execute_transaction(_param,0,0,0,100,OPERATION_ALU_L_SUB     ,TYPE_ALU,0,0         ,0x12344321,0x1       ,0              ,1,63,0x12344320,1,15,0              ,EXCEPTION_NONE     ,0));
//   transaction_in.push_back(execute_transaction(_param,0,0,0,101,OPERATION_ALU_L_SUB     ,TYPE_ALU,0,0         ,0x12345678,0xffffffff,0              ,1,56,0x12345679,1,3 ,0              ,EXCEPTION_NONE     ,0));
//   transaction_in.push_back(execute_transaction(_param,0,0,0,102,OPERATION_ALU_L_SUB     ,TYPE_ALU,0,0         ,0x12345678,0x12345678,0              ,1,56,0x0       ,1,3 ,0              ,EXCEPTION_NONE     ,0));
//   transaction_in.push_back(execute_transaction(_param,0,0,0,103,OPERATION_ALU_L_SUB     ,TYPE_ALU,0,0         ,0x0       ,0x0       ,0              ,1,56,0x0       ,1,3 ,0              ,EXCEPTION_NONE     ,0));
//   transaction_in.push_back(execute_transaction(_param,0,0,0,104,OPERATION_ALU_L_SUB     ,TYPE_ALU,0,0         ,0x70000000,0x90000000,0              ,1,56,0x0       ,1,3 ,FLAG_CY        ,EXCEPTION_NONE     ,0));
//   transaction_in.push_back(execute_transaction(_param,0,0,0,105,OPERATION_ALU_L_SUB     ,TYPE_ALU,0,0         ,0x80001000,0x80000000,0              ,1,1 ,0x1000    ,1,0 ,FLAG_CY|FLAG_OV,EXCEPTION_ALU_RANGE,0));
//   transaction_in.push_back(execute_transaction(_param,0,0,0,106,OPERATION_ALU_L_SUB     ,TYPE_ALU,0,0         ,0x00000001,0x7fffffff,FLAG_CY|FLAG_OV,1,1 ,0x80000000,1,0 ,        FLAG_OV,EXCEPTION_ALU_RANGE,0));

  transaction_in.push_back(execute_transaction(_param,0,0,0,120,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,121,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,122,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,123,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,124,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,125,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,126,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,127,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,128,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,129,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,130,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,131,OPERATION_TEST_L_SFEQ    ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,140,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,141,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,142,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,143,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,144,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,145,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,146,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,147,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,148,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,149,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,150,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,151,OPERATION_TEST_L_SFNE    ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,150,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,151,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,152,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,153,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,154,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,155,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,156,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,157,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,158,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,159,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,160,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,161,OPERATION_TEST_L_SFGEU   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,170,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,171,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,172,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,173,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,174,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,175,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,176,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,177,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,178,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,179,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,180,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,181,OPERATION_TEST_L_SFGTU   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,190,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,191,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,192,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,193,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,194,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,195,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,196,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,197,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,198,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,199,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,200,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,201,OPERATION_TEST_L_SFLEU   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,210,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,211,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,212,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,213,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,214,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,215,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,216,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,217,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,218,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,219,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,220,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,221,OPERATION_TEST_L_SFLTU   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,230,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,231,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,232,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,233,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,234,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,235,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,236,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,237,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,238,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,239,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,240,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,241,OPERATION_TEST_L_SFGES   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,250,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,251,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,252,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,253,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,254,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,255,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,256,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,257,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,258,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,259,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,260,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,261,OPERATION_TEST_L_SFGTS   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,270,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,271,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,272,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,273,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,274,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,275,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,276,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,277,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,278,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,279,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,280,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,281,OPERATION_TEST_L_SFLES   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,290,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0xdead    ,0xdead    ,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == +
  transaction_in.push_back(execute_transaction(_param,0,0,0,291,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0x25071959,0x21071981,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,292,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0x21071981,0x25071959,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // + <  +
  transaction_in.push_back(execute_transaction(_param,0,0,0,293,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - == -
  transaction_in.push_back(execute_transaction(_param,0,0,0,294,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0xdeadbabe,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // - >  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,295,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0xdeadbabe,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  -
  transaction_in.push_back(execute_transaction(_param,0,0,0,296,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0x21524111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - == + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,297,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0x11111111,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - >  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,298,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0xdeadbeef,0x33333333,0              ,0,63,0x0       ,1,15,FLAG_F         ,EXCEPTION_NONE     ,0)); // - <  + (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,299,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0x21524111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + == - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,300,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0x33333333,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + >  - (in unsigned)
  transaction_in.push_back(execute_transaction(_param,0,0,0,301,OPERATION_TEST_L_SFLTS   ,TYPE_TEST,0,0         ,0x11111111,0xdeadbeef,0              ,0,63,0x0       ,1,15,0              ,EXCEPTION_NONE     ,0)); // + <  - (in unsigned)

  transaction_in.push_back(execute_transaction(_param,0,0,0,400,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_ICACHE<<11,   3,0xdeadbeef,0              ,0,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_SPR_ACCESS_NOT_COMPLETE,0,(GROUP_ICACHE<<11)|   3));
  transaction_in.push_back(execute_transaction(_param,0,0,0,401,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_ICACHE<<11,   5,0xdeadbeef,0              ,0,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_SPR_ACCESS_NOT_COMPLETE,0,(GROUP_ICACHE<<11)|   5));
  transaction_in.push_back(execute_transaction(_param,0,0,0,402,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   0,0xdeadbeef,0              ,0,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_SPR_ACCESS_INVALID     ,0,(GROUP_MAC   <<11)|   0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,403,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0xdeadbeef,0              ,0,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,404,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   0,0x12345678,0              ,1,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_SPR_ACCESS_INVALID     ,0,(GROUP_MAC   <<11)|   0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,405,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x12345678,0              ,1,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));

  if (_param->_nb_ooo_engine > 1)
    {
  transaction_in.push_back(execute_transaction(_param,0,0,1,406,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x12345678,0              ,0,63,0x12345678,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,407,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x0       ,0              ,1,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,1,408,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x0       ,0              ,1,63,0x12345678,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
    }
  // TEST MAC Unit
  transaction_in.push_back(execute_transaction(_param,0,0,0,409,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0xbebebeef,0              ,0,63,0xbebebeef,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,410,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   2,0x21071981,0              ,0,63,0x21071981,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   2));

  transaction_in.push_back(execute_transaction(_param,0,0,0,411,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x0       ,0              ,1,63,0xbebebeef,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,412,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   2,0x0       ,0              ,1,63,0x21071981,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,413,OPERATION_SPECIAL_L_MACRC   ,TYPE_SPECIAL,0,0x0       , 0x0      ,0x0       ,0              ,1,63,0xbebebeef,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0));

  transaction_in.push_back(execute_transaction(_param,0,0,0,414,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x0       ,0              ,1,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,415,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   2,0x0       ,0              ,1,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,416,OPERATION_SPECIAL_L_MACRC   ,TYPE_SPECIAL,0,0x0       , 0x0      ,0x0       ,0              ,1,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0));


  transaction_in.push_back(execute_transaction(_param,0,0,0,417,OPERATION_SPECIAL_L_MAC     ,TYPE_SPECIAL,0,0x0       ,0x22071981,0x1234567 ,0              ,0,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0));

  transaction_in.push_back(execute_transaction(_param,0,0,0,418,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x0       ,0              ,1,63,0x985e07e7,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,419,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   2,0x0       ,0              ,1,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,420,OPERATION_SPECIAL_L_MAC     ,TYPE_SPECIAL,1,0x22071981,0x1234567 ,0x0       ,0              ,0,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0));

  transaction_in.push_back(execute_transaction(_param,0,0,0,421,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x0       ,0              ,1,63,0x30bc0fce,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,422,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   2,0x0       ,0              ,1,63,0x1       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,423,OPERATION_SPECIAL_L_MSB     ,TYPE_SPECIAL,1,0xdeadbeef,0x1945    ,0x0       ,0              ,0,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0));
  
  transaction_in.push_back(execute_transaction(_param,0,0,0,424,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   1,0x0       ,0              ,1,63,0x34424263,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,425,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_MAC   <<11,   2,0x0       ,0              ,1,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_MAC   <<11)|   2));

  transaction_in.push_back(execute_transaction(_param,0,0,0,500,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_3<<11, 0,0xdeadbeef,0              ,0,63,0xdeadbeef,0, 0,0              ,EXCEPTION_ALU_SPR_ACCESS_INVALID,0,(GROUP_CUSTOM_3<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,500,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_3<<11, 0,0xdeadbeef,0              ,0,63,0xdeadbeef,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_3<<11)|0));

  transaction_in.push_back(execute_transaction(_param,0,0,0,501,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_3<<11, 1,0x3       ,0              ,0,63,0x3       ,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_3<<11)|1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,502,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_3<<11, 2,0x7       ,0              ,0,63,0x7       ,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_3<<11)|2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,503,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_3<<11, 0,0x0       ,0              ,1,63,0xdeadbeef,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_3<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,504,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_3<<11, 1,0x0       ,0              ,1,63,0x3       ,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_3<<11)|1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,505,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_3<<11, 2,0x0       ,0              ,1,63,0x7       ,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_3<<11)|2));


  transaction_in.push_back(execute_transaction(_param,0,0,0,506,OPERATION_CUSTOM_L_4    ,TYPE_CUSTOM,0,0x0       ,0x21071981,0x0       ,0              ,1,63,0x9ae2802f,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,507,OPERATION_CUSTOM_L_8    ,TYPE_CUSTOM,0,0x0       ,0x9ae2802f,0x0       ,0              ,1,63,0x21071981,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0));



  transaction_in.push_back(execute_transaction(_param,0,0,0,600,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 1,0x0       ,0              ,1,63,0xdeadbeef,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|1));
  transaction_in.push_back(execute_transaction(_param,0,0,0,601,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 2,0x0       ,0              ,1,63,0x666     ,0, 2,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,602,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 3,0x0       ,0              ,1,63,0xffffffff,0, 3,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|3));
  transaction_in.push_back(execute_transaction(_param,0,0,0,603,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 3,0x0       ,0              ,0,63,0x0       ,0, 0,0              ,EXCEPTION_ALU_SPR_ACCESS_INVALID     ,0,(GROUP_CUSTOM_7<<11)|3));
  transaction_in.push_back(execute_transaction(_param,0,0,0,604,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 2,0x0       ,0              ,0,63,0x0       ,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,605,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 2,0x0       ,0              ,1,63,0x666     ,0, 2,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,606,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 2,0x12345678,0              ,0,63,0x12345678,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|2));
  transaction_in.push_back(execute_transaction(_param,0,0,0,607,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 2,0x0       ,0              ,1,63,0x12345678,0, 2,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|2));

  transaction_in.push_back(execute_transaction(_param,0,0,0,610,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xbebe    ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,611,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x4add6dda,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,612,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x96c7b0fe,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,613,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xeba5179a,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,614,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x17ebab3e,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,615,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xcd37395a,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,616,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x7325ad7e,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,617,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xb4ad31a ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,618,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x5a4eb7be,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,619,OPERATION_SPECIAL_L_MTSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 3,0xf       ,0              ,0,63,0xf       ,0, 1,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|3));

  transaction_in.push_back(execute_transaction(_param,0,0,0,620,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xbd76e4da,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,621,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xe       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,622,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xa       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,623,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x3       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,624,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x1       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,625,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0x5       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,626,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xc       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,627,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xe       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));
  transaction_in.push_back(execute_transaction(_param,0,0,0,628,OPERATION_SPECIAL_L_MFSPR   ,TYPE_SPECIAL,1,GROUP_CUSTOM_7<<11, 0,0x0       ,0              ,1,63,0xa       ,0, 0,0              ,EXCEPTION_ALU_NONE                   ,0,(GROUP_CUSTOM_7<<11)|0));

  LABEL("Reset");
  in_NRESET.write(0);

  in_EXECUTE_IN_VAL .write(0);
  in_EXECUTE_OUT_ACK.write(0);

  SC_START(5);
  in_NRESET.write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      nb_transaction_out = transaction_in.size();

      LABEL("Iteration %d",iteration);

      while (nb_transaction_out > 0)
	{
	  Tcontrol_t val = ((rand()%100) < percent_transaction_execute_in) and not transaction_in.empty();
	  in_EXECUTE_IN_VAL .write(val);
	  in_EXECUTE_OUT_ACK.write((rand()%100) < percent_transaction_execute_out);
	  
	  if (val)
	    {
	      if (_param->_have_port_context_id)
	      in_EXECUTE_IN_CONTEXT_ID    .write(transaction_in.front()._context_id   );
	      if (_param->_have_port_front_end_id)
	      in_EXECUTE_IN_FRONT_END_ID  .write(transaction_in.front()._front_end_id );
	      if (_param->_have_port_ooo_engine_id)
	      in_EXECUTE_IN_OOO_ENGINE_ID .write(transaction_in.front()._ooo_engine_id);
	      if (_param->_have_port_packet_id)
	      in_EXECUTE_IN_PACKET_ID     .write(transaction_in.front()._packet_id    );
	      in_EXECUTE_IN_OPERATION     .write(transaction_in.front()._operation    );
	      in_EXECUTE_IN_TYPE          .write(transaction_in.front()._type         );
	      in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE.write(0);
	      if (_param->_have_port_load_queue_ptr)
	      in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE .write(0);
	      in_EXECUTE_IN_HAS_IMMEDIAT  .write(transaction_in.front()._has_immediat );
	      in_EXECUTE_IN_IMMEDIAT      .write(transaction_in.front()._immediat     );
	      in_EXECUTE_IN_DATA_RA       .write(transaction_in.front()._data_ra      );
	      in_EXECUTE_IN_DATA_RB       .write(transaction_in.front()._data_rb      );
	      in_EXECUTE_IN_DATA_RC       .write(transaction_in.front()._data_rc      );
	      in_EXECUTE_IN_WRITE_RD      .write(transaction_in.front()._write_rd     );
	      in_EXECUTE_IN_NUM_REG_RD    .write(transaction_in.front()._num_reg_rd   );
	      in_EXECUTE_IN_WRITE_RE      .write(transaction_in.front()._write_re     );
	      in_EXECUTE_IN_NUM_REG_RE    .write(transaction_in.front()._num_reg_re   );
	    }
	  
	  SC_START(0);
	  
	  if (out_EXECUTE_OUT_VAL.read() and  in_EXECUTE_OUT_ACK.read())
	    {
	      // TEST
	      if (_param->_have_port_packet_id)
	      TEST(Tpacket_t         , out_EXECUTE_OUT_PACKET_ID    .read(), transaction_out.front()._packet_id    );
	      if (_param->_have_port_context_id)
	      TEST(Tcontext_t        , out_EXECUTE_OUT_CONTEXT_ID   .read(), transaction_out.front()._context_id   );
	      if (_param->_have_port_front_end_id)
	      TEST(Tcontext_t        , out_EXECUTE_OUT_FRONT_END_ID .read(), transaction_out.front()._front_end_id );
	      if (_param->_have_port_ooo_engine_id)
	      TEST(Tcontext_t        , out_EXECUTE_OUT_OOO_ENGINE_ID.read(), transaction_out.front()._ooo_engine_id);
	    //TEST(Toperation_t      , out_EXECUTE_OUT_OPERATION    .read(), transaction_out.front()._operation    );
	      TEST(Ttype_t           , out_EXECUTE_OUT_TYPE         .read(), transaction_out.front()._type         );
	      TEST(Tcontrol_t        , out_EXECUTE_OUT_WRITE_RE     .read(), transaction_out.front()._write_re     );
	      TEST(Tgeneral_address_t, out_EXECUTE_OUT_NUM_REG_RD   .read(), transaction_out.front()._num_reg_rd   );
	      TEST(Tspecial_address_t, out_EXECUTE_OUT_NUM_REG_RE   .read(), transaction_out.front()._num_reg_re   );
	      TEST(Texception_t      , out_EXECUTE_OUT_EXCEPTION    .read(), transaction_out.front()._exception    );
	      TEST(Tcontrol_t        , out_EXECUTE_OUT_NO_SEQUENCE  .read(), transaction_out.front()._no_sequence  );


	      bool just_do_it = true;
	      if ((transaction_out.front()._type      == TYPE_SPECIAL) and 
		  (transaction_out.front()._operation == OPERATION_SPECIAL_L_MFSPR))
		{
		  just_do_it = false;
		  TEST(Tcontrol_t        , out_EXECUTE_OUT_WRITE_RD     .read(), out_EXECUTE_OUT_EXCEPTION.read() == EXCEPTION_ALU_NONE);
		  if (out_EXECUTE_OUT_WRITE_RD     .read())
		  TEST(Tgeneral_data_t   , out_EXECUTE_OUT_DATA_RD      .read(), transaction_out.front()._data_rd      );
		  TEST(Tgeneral_data_t   , out_EXECUTE_OUT_ADDRESS      .read(), transaction_out.front()._address      );
		  break;
		}

	      if ((transaction_out.front()._type      == TYPE_SPECIAL) and 
		  (transaction_out.front()._operation == OPERATION_SPECIAL_L_MTSPR))
		{
		  just_do_it = false;
		  TEST(Tcontrol_t        , out_EXECUTE_OUT_WRITE_RD     .read(), transaction_out.front()._write_rd     );
		  TEST(Tgeneral_data_t   , out_EXECUTE_OUT_DATA_RD      .read(), transaction_out.front()._data_rd      );
		  TEST(Tgeneral_data_t   , out_EXECUTE_OUT_ADDRESS      .read(), transaction_out.front()._address      );
		  break;
		}
	      
	      if (just_do_it)
		{
		  TEST(Tcontrol_t        , out_EXECUTE_OUT_WRITE_RD     .read(), transaction_out.front()._write_rd     );
		  if (transaction_out.front()._write_rd)
		    TEST(Tgeneral_data_t   , out_EXECUTE_OUT_DATA_RD      .read(), transaction_out.front()._data_rd      );
		  if (transaction_out.front()._write_re)
		    TEST(Tspecial_data_t   , out_EXECUTE_OUT_DATA_RE      .read(), transaction_out.front()._data_re      );
		  if (transaction_out.front()._no_sequence)
		    TEST(Tgeneral_data_t   , out_EXECUTE_OUT_ADDRESS      .read(), transaction_out.front()._address      );
		}

	      transaction_out.pop_front();

	      nb_transaction_out--;
	    }
	  
	  if ( in_EXECUTE_IN_VAL .read() and out_EXECUTE_IN_ACK .read())
	    {
	      transaction_out.push_back(transaction_in.front());
	      transaction_in.pop_front();
	    }

	  SC_START(1);
	}

    }
  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

#endif

  delete _Functionnal_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
