/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");
    
    Parameters_test test("Load_store_unit");

    switch (_speculative_load)
      {
      case SPECULATIVE_LOAD_COMMIT :
	{
	  if (not (_nb_bypass_memory == 0))
	    test.error("Bypass memory is not supported. Please wait a next revision.");
 
	  break;
	}
      case NO_SPECULATIVE_LOAD     :
      case SPECULATIVE_LOAD_ACCESS :
      // case SPECULATIVE_LOAD_BYPASS :
      default                      :
	{
	  if (not (_nb_bypass_memory == 0))
	    test.error("In the load scheme '"+toString(_speculative_load)+"', they have none bypass.");

	  test.error("Speculative load scheme '"+toString(_speculative_load)+"' is not supported. Please wait a next revision.");
	  break;
	}
      }

    if (not (_size_store_queue >= 2))
      test.error("Store queue must have at less two slot.");

    if (not (_nb_bypass_memory <= _size_load_queue))
      test.error("Bypass number must be less than load_queue's size.");

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");

    return test;

  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
