/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Execute_loop.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {


#undef  FUNCTION
#define FUNCTION "Execute_loop::deallocation"
  void Execute_loop::deallocation (void)
  {
    log_printf(FUNC,Execute_loop,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete     in_CLOCK ;
	delete     in_NRESET;

	// ~~~~~[ Interface "execute_loop_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_EXECUTE_LOOP_IN_VAL                  ;
	delete [] out_EXECUTE_LOOP_IN_ACK                  ;
	if (_param->_have_port_context_id)
	delete []  in_EXECUTE_LOOP_IN_CONTEXT_ID           ;
	if (_param->_have_port_front_end_id)
	delete []  in_EXECUTE_LOOP_IN_FRONT_END_ID         ;
	if (_param->_have_port_ooo_engine_id)
	delete []  in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ;
	if (_param->_have_port_packet_id)
	delete []  in_EXECUTE_LOOP_IN_PACKET_ID            ;
	delete []  in_EXECUTE_LOOP_IN_OPERATION            ;
	delete []  in_EXECUTE_LOOP_IN_TYPE                 ;
	delete []  in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE;
	if (_param->_have_port_load_queue_ptr)
	delete []  in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ;
	delete []  in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ;
	delete []  in_EXECUTE_LOOP_IN_IMMEDIAT             ;
	delete []  in_EXECUTE_LOOP_IN_READ_RA              ;
	delete []  in_EXECUTE_LOOP_IN_NUM_REG_RA           ;
	delete []  in_EXECUTE_LOOP_IN_READ_RB              ;
	delete []  in_EXECUTE_LOOP_IN_NUM_REG_RB           ;
	delete []  in_EXECUTE_LOOP_IN_READ_RC              ;
	delete []  in_EXECUTE_LOOP_IN_NUM_REG_RC           ;
	delete []  in_EXECUTE_LOOP_IN_WRITE_RD             ;
	delete []  in_EXECUTE_LOOP_IN_NUM_REG_RD           ;
	delete []  in_EXECUTE_LOOP_IN_WRITE_RE             ;
	delete []  in_EXECUTE_LOOP_IN_NUM_REG_RE           ;

	// ~~~~~[ Interface "execute_loop_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete [] out_EXECUTE_LOOP_OUT_VAL                 ;
	delete []  in_EXECUTE_LOOP_OUT_ACK                 ;
	if (_param->_have_port_context_id)
	delete [] out_EXECUTE_LOOP_OUT_CONTEXT_ID          ;
	if (_param->_have_port_front_end_id)
	delete [] out_EXECUTE_LOOP_OUT_FRONT_END_ID        ;
	if (_param->_have_port_ooo_engine_id)
	delete [] out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ;
	if (_param->_have_port_packet_id)
	delete [] out_EXECUTE_LOOP_OUT_PACKET_ID           ;
      //delete [] out_EXECUTE_LOOP_OUT_OPERATION           ;
      //delete [] out_EXECUTE_LOOP_OUT_TYPE                ;
	delete [] out_EXECUTE_LOOP_OUT_FLAGS               ;
	delete [] out_EXECUTE_LOOP_OUT_EXCEPTION           ;
	delete [] out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ;
	delete [] out_EXECUTE_LOOP_OUT_ADDRESS             ;

	// ~~~~~[ Interface "dcache_req"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete [] out_DCACHE_REQ_VAL                       ;
	delete []  in_DCACHE_REQ_ACK                       ;
	if (_param->_have_port_dcache_context_id)
	delete [] out_DCACHE_REQ_CONTEXT_ID                ;
	delete [] out_DCACHE_REQ_PACKET_ID                 ;
	delete [] out_DCACHE_REQ_ADDRESS                   ;
	delete [] out_DCACHE_REQ_TYPE                      ;
	delete [] out_DCACHE_REQ_WDATA                     ;

	// ~~~~~[ Interface "dcache_rsp"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_DCACHE_RSP_VAL                       ;
	delete [] out_DCACHE_RSP_ACK                       ;
	if (_param->_have_port_dcache_context_id)
	delete []  in_DCACHE_RSP_CONTEXT_ID                ;
	delete []  in_DCACHE_RSP_PACKET_ID                 ;
	delete []  in_DCACHE_RSP_RDATA                     ;
	delete []  in_DCACHE_RSP_ERROR                     ;
    
	// ~~~~~[ Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_INSERT_ROB_VAL                       ;
	delete [] out_INSERT_ROB_ACK                       ;
	delete []  in_INSERT_ROB_RD_USE                    ;
	delete []  in_INSERT_ROB_RD_NUM_REG                ;
	delete []  in_INSERT_ROB_RE_USE                    ;
	delete []  in_INSERT_ROB_RE_NUM_REG                ;

	// ~~~~~[ Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_RETIRE_ROB_VAL                       ;
	delete [] out_RETIRE_ROB_ACK                       ;
	delete []  in_RETIRE_ROB_RD_OLD_USE                ; 
	delete []  in_RETIRE_ROB_RD_OLD_NUM_REG            ;
	delete []  in_RETIRE_ROB_RD_NEW_USE                ;
	delete []  in_RETIRE_ROB_RD_NEW_NUM_REG            ;
	delete []  in_RETIRE_ROB_RE_OLD_USE                ; 
	delete []  in_RETIRE_ROB_RE_OLD_NUM_REG            ;
	delete []  in_RETIRE_ROB_RE_NEW_USE                ;
	delete []  in_RETIRE_ROB_RE_NEW_NUM_REG            ;
      }
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete    _component;
    delete [] _component_read_unit                   ;
    delete [] _component_functionnal_unit            ;
    delete [] _component_load_store_unit             ;
    delete [] _component_write_unit                  ;
    delete [] _component_read_unit_to_execution_unit ;
    delete [] _component_execution_unit_to_write_unit;
    delete [] _component_register_unit               ;
    
    log_printf(FUNC,Execute_loop,FUNCTION,"End");
  };

}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
