#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Direction_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace direction_glue {


#undef  FUNCTION
#define FUNCTION "Direction_Glue::genMealy_predict"
  void Direction_Glue::genMealy_predict (void)
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");

    // constant direction : never / always 
    switch (_param->_predictor_scheme)
      {
      case PREDICTOR_STATIC    :
	{
	  for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	    PORT_WRITE(out_PREDICT_DIRECTION   [i], PORT_READ(in_PREDICT_STATIC    [i]));
	  
	  break;
	}
      case PREDICTOR_LAST_TAKE :
	{
	  for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	    PORT_WRITE(out_PREDICT_DIRECTION   [i], PORT_READ(in_PREDICT_LAST_TAKE [i]));

	  break;
	}
      case PREDICTOR_COUNTER   :
      case PREDICTOR_LOCAL     :
      case PREDICTOR_GLOBAL    :
      case PREDICTOR_META      :
      case PREDICTOR_CUSTOM    :
	{
	  for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	    {
	      // not use :
	      // in_PREDICT_LAST_TAKE       
	      // in_PREDICT_STATIC

	      PORT_WRITE(out_PREDICT_PREDICTOR_VAL         [i], PORT_READ(in_PREDICT_VAL                 [i]));
	      PORT_WRITE(out_PREDICT_ACK                   [i], PORT_READ(in_PREDICT_PREDICTOR_ACK       [i]));
	      PORT_WRITE(out_PREDICT_PREDICTOR_ADDRESS_SRC [i], PORT_READ(in_PREDICT_ADDRESS_SRC         [i]));
	      PORT_WRITE(out_PREDICT_HISTORY               [i], PORT_READ(in_PREDICT_PREDICTOR_HISTORY   [i]));
	      PORT_WRITE(out_PREDICT_DIRECTION             [i], PORT_READ(in_PREDICT_PREDICTOR_DIRECTION [i]));
	    }

	  break;
	}
      default :
	{
	  ERRORMORPHEO(FUNCTION,"No valid predictor scheme");
	  break;
	}
      }


    
    log_printf(FUNC,Direction_Glue,FUNCTION,"End");
  };

}; // end namespace direction_glue
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
