#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::genMealy_push_spr"
  void Free_List_unit::genMealy_push_spr (void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    bool bank_use [_param->_nb_bank];
    for (uint32_t i=0; i<_param->_nb_bank; i++)
      bank_use [i] = false;

    for (uint32_t i=0; i<_param->_nb_push; i++)
      {
	bool spr_ack = not PORT_READ(in_PUSH_SPR_VAL[i]);

	if (not spr_ack)
	  {
	    // num_bank : MSB
	    uint32_t bank = PORT_READ(in_PUSH_SPR_NUM_REG[i]) >> _param->_bank_spr_size_slot;
	    
	    if (not bank_use [bank])
	      {
		// find
		spr_ack = true;
		internal_PUSH_SPR_BANK [i] = bank;
		bank_use [bank] = true;
	      }
	  }

	internal_PUSH_SPR_ACK [i] = spr_ack;
	PORT_WRITE(out_PUSH_SPR_ACK [i], internal_PUSH_SPR_ACK [i]);
      }
    
    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
