/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/Max.h"
#include "Behavioural/include/Allocation.h"

#define NB_ITERATION  64
#define CYCLE_MAX     (1024*NB_ITERATION)

#define LABEL(str...)							\
  {									\
    msg (_("{%d} "),static_cast<uint32_t>(sc_simulation_time()));	\
    msg (str);								\
    msg (_("\n"));							\
  } while(0)

#define SC_START(cycle_offset)                                                       \
  do									             \
    {									             \
      /*cout << "SC_START (begin)" << endl;*/				             \
									             \
      uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time());          \
      if (cycle_offset != 0)						             \
	{								             \
	  cout << "##########[ cycle "<< cycle_current+cycle_offset << " ]" << endl; \
	}								             \
									             \
      if (cycle_current > CYCLE_MAX)					             \
	{								             \
	  TEST_KO("Maximal cycles Reached");				             \
	}								             \
									             \
      sc_start(cycle_offset);						             \
									             \
      /*cout << "SC_START (end  )" << endl;*/				             \
    } while(0)

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Register_Address_Translation_unit * _Register_Address_Translation_unit = new Register_Address_Translation_unit (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_RENAME_VAL               ," in_RENAME_VAL               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_RENAME_ACK               ,"out_RENAME_ACK               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_FRONT_END_ID      ," in_RENAME_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_CONTEXT_ID        ," in_RENAME_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RA_LOG    ," in_RENAME_NUM_REG_RA_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RB_LOG    ," in_RENAME_NUM_REG_RB_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RC_LOG    ," in_RENAME_NUM_REG_RC_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RD_LOG    ," in_RENAME_NUM_REG_RD_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RE_LOG    ," in_RENAME_NUM_REG_RE_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_RENAME_NUM_REG_RA_PHY    ,"out_RENAME_NUM_REG_RA_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_RENAME_NUM_REG_RB_PHY    ,"out_RENAME_NUM_REG_RB_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_RENAME_NUM_REG_RC_PHY    ,"out_RENAME_NUM_REG_RC_PHY    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_RENAME_NUM_REG_RD_PHY_OLD,"out_RENAME_NUM_REG_RD_PHY_OLD",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_RENAME_NUM_REG_RE_PHY_OLD,"out_RENAME_NUM_REG_RE_PHY_OLD",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL( in_INSERT_VAL               ," in_INSERT_VAL               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_ACK               ,"out_INSERT_ACK               ",Tcontrol_t        ,_param->_nb_inst_insert);
//ALLOC1_SC_SIGNAL( in_INSERT_FRONT_END_ID      ," in_INSERT_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_inst_insert);
//ALLOC1_SC_SIGNAL( in_INSERT_CONTEXT_ID        ," in_INSERT_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_WRITE_RD          ," in_INSERT_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_WRITE_RE          ," in_INSERT_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RD_LOG    ," in_INSERT_NUM_REG_RD_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RE_LOG    ," in_INSERT_NUM_REG_RE_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RD_PHY    ," in_INSERT_NUM_REG_RD_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RE_PHY    ," in_INSERT_NUM_REG_RE_PHY    ",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL( in_RETIRE_VAL               ," in_RETIRE_VAL               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_ACK               ,"out_RETIRE_ACK               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_FRONT_END_ID      ," in_RETIRE_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_CONTEXT_ID        ," in_RETIRE_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_EVENT_STATE       ," in_RETIRE_EVENT_STATE       ",Tevent_state_t    ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RD          ," in_RETIRE_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RE          ," in_RETIRE_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_LOG    ," in_RETIRE_NUM_REG_RD_LOG    ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_LOG    ," in_RETIRE_NUM_REG_RE_LOG    ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_OLD," in_RETIRE_NUM_REG_RD_PHY_OLD",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_OLD," in_RETIRE_NUM_REG_RE_PHY_OLD",Tspecial_address_t,_param->_nb_inst_retire);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Register_Address_Translation_unit.\n"),name.c_str());

  (*(_Register_Address_Translation_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Register_Address_Translation_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_VAL               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_RENAME_ACK               ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_FRONT_END_ID      ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_CONTEXT_ID        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_NUM_REG_RA_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_NUM_REG_RB_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_NUM_REG_RC_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_NUM_REG_RD_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RENAME_NUM_REG_RE_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_RENAME_NUM_REG_RA_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_RENAME_NUM_REG_RB_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_RENAME_NUM_REG_RC_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_RENAME_NUM_REG_RD_PHY_OLD,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_RENAME_NUM_REG_RE_PHY_OLD,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_VAL               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_INSERT_ACK               ,_param->_nb_inst_insert);
//if (_param->_have_port_front_end_id)
//INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_FRONT_END_ID      ,_param->_nb_inst_insert);
//if (_param->_have_port_context_id)
//INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_CONTEXT_ID        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_WRITE_RD          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_WRITE_RE          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_NUM_REG_RD_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_NUM_REG_RE_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_NUM_REG_RD_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_INSERT_NUM_REG_RE_PHY    ,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_VAL               ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit,out_RETIRE_ACK               ,_param->_nb_inst_retire);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_FRONT_END_ID      ,_param->_nb_inst_retire);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_CONTEXT_ID        ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_EVENT_STATE       ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_WRITE_RD          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_WRITE_RE          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_NUM_REG_RD_LOG    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_NUM_REG_RE_LOG    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_NUM_REG_RD_PHY_OLD,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_Address_Translation_unit, in_RETIRE_NUM_REG_RE_PHY_OLD,_param->_nb_inst_retire);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_insert = 75;
  const  int32_t percent_transaction_retire = 75;

  uint32_t max_nb_context = max(_param->_nb_context,_param->_nb_front_end);

  Tgeneral_address_t rat_gpr      [_param->_nb_front_end][max_nb_context][_param->_nb_general_register_logic];
  Tspecial_address_t rat_spr      [_param->_nb_front_end][max_nb_context][_param->_nb_special_register_logic];
  bool               rat_gpr_updt [_param->_nb_front_end][max_nb_context][_param->_nb_general_register_logic];
  bool               rat_spr_updt [_param->_nb_front_end][max_nb_context][_param->_nb_special_register_logic];
  
  uint32_t gpr=1;
  uint32_t spr=0;
  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    for (uint32_t j=0; j<_param->_nb_context[i]; j++)
      {
	rat_gpr [i][j][0] = 0;

	for (uint32_t k=1; k<_param->_nb_general_register_logic; k++)
	  {
	    rat_gpr      [i][j][k] = gpr++;
	    rat_gpr_updt [i][j][k] = false;
	  }
	for (uint32_t k=0; k<_param->_nb_special_register_logic; k++)
	  {
	    rat_spr      [i][j][k] = spr++;
	    rat_spr_updt [i][j][k] = false;
	  }
      }

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      int32_t nb_request;
      
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  in_RENAME_VAL [i]->write(0);
	  in_INSERT_VAL [i]->write(0);
	}
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	in_RETIRE_VAL [i]->write(0);

      nb_request = 32;
      while (nb_request > 1)
	{
	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tcontrol_t val = (rand()%100)<percent_transaction_insert;
	      
	      Tcontext_t front_end_id = rand() % _param->_nb_front_end;

	      in_RENAME_VAL             [i]->write(val);
	      in_RENAME_FRONT_END_ID    [i]->write(front_end_id);
	      in_RENAME_CONTEXT_ID      [i]->write(rand() % (_param->_nb_context[front_end_id]));
	      in_RENAME_NUM_REG_RA_LOG  [i]->write((rand() % (_param->_nb_general_register_logic-1))+1);
	      in_RENAME_NUM_REG_RB_LOG  [i]->write((rand() % (_param->_nb_general_register_logic-1))+1);
	      in_RENAME_NUM_REG_RC_LOG  [i]->write( rand() %  _param->_nb_special_register_logic);
	      in_RENAME_NUM_REG_RD_LOG  [i]->write((rand() % (_param->_nb_general_register_logic-1))+1);
	      in_RENAME_NUM_REG_RE_LOG  [i]->write( rand() %  _param->_nb_special_register_logic);
	      in_INSERT_VAL             [i]->write(val);
	      in_INSERT_WRITE_RD        [i]->write(rand() % 2);
	      in_INSERT_WRITE_RE        [i]->write(rand() % 2);
	      in_INSERT_NUM_REG_RD_LOG  [i]->write((rand() % (_param->_nb_general_register_logic-1))+1);
	      in_INSERT_NUM_REG_RE_LOG  [i]->write( rand() %  _param->_nb_special_register_logic);
	      in_INSERT_NUM_REG_RD_PHY  [i]->write(rand() % _param->_nb_general_register);
	      in_INSERT_NUM_REG_RE_PHY  [i]->write(rand() % _param->_nb_special_register);
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    {
	      Tcontrol_t val = (rand()%100)<percent_transaction_retire;
	      
	      Tcontext_t front_end_id = rand() % _param->_nb_front_end;

	      in_RETIRE_VAL                [i]->write(val);
	      in_RETIRE_FRONT_END_ID       [i]->write(front_end_id);
	      in_RETIRE_CONTEXT_ID         [i]->write(rand() % (_param->_nb_context[front_end_id]));
	      in_RETIRE_EVENT_STATE        [i]->write(EVENT_STATE_NO_EVENT);
	      in_RETIRE_WRITE_RD           [i]->write(rand() % 2);
	      in_RETIRE_WRITE_RE           [i]->write(rand() % 2);
	      in_RETIRE_NUM_REG_RD_LOG     [i]->write(rand() % _param->_nb_general_register_logic);
	      in_RETIRE_NUM_REG_RE_LOG     [i]->write(rand() % _param->_nb_special_register_logic);
	      in_RETIRE_NUM_REG_RD_PHY_OLD [i]->write(rand() % _param->_nb_general_register);
	      in_RETIRE_NUM_REG_RE_PHY_OLD [i]->write(rand() % _param->_nb_special_register);
	    }

	  SC_START(1);
	  

	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tcontext_t front_end_id = in_RENAME_FRONT_END_ID [i]->read();
	      Tcontext_t context_id   = in_RENAME_CONTEXT_ID   [i]->read();
	      if (in_INSERT_VAL [i]->read() and out_INSERT_ACK [i]->read())
		{
		  if (in_INSERT_WRITE_RD [i]->read() == 1)
		    rat_gpr[front_end_id][context_id][in_INSERT_NUM_REG_RD_LOG[i]->read()] = in_INSERT_NUM_REG_RD_PHY[i]->read();
		  if (in_INSERT_WRITE_RE [i]->read() == 1)
		    rat_spr[front_end_id][context_id][in_INSERT_NUM_REG_RE_LOG[i]->read()] = in_INSERT_NUM_REG_RE_PHY[i]->read();
		}
	    }
	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tcontext_t front_end_id = in_RENAME_FRONT_END_ID [i]->read();
	      Tcontext_t context_id   = in_RENAME_CONTEXT_ID   [i]->read();
	      if (in_RENAME_VAL [i]->read() and out_RENAME_ACK [i]->read())
		{
		  nb_request --;

		  TEST(Tgeneral_address_t,out_RENAME_NUM_REG_RA_PHY    [i]->read(), rat_gpr[front_end_id][context_id][in_RENAME_NUM_REG_RA_LOG[i]->read()]);
		  TEST(Tgeneral_address_t,out_RENAME_NUM_REG_RB_PHY    [i]->read(), rat_gpr[front_end_id][context_id][in_RENAME_NUM_REG_RB_LOG[i]->read()]);
		  TEST(Tspecial_address_t,out_RENAME_NUM_REG_RC_PHY    [i]->read(), rat_spr[front_end_id][context_id][in_RENAME_NUM_REG_RC_LOG[i]->read()]);
		  TEST(Tgeneral_address_t,out_RENAME_NUM_REG_RD_PHY_OLD[i]->read(), rat_gpr[front_end_id][context_id][in_RENAME_NUM_REG_RD_LOG[i]->read()]);
		  TEST(Tspecial_address_t,out_RENAME_NUM_REG_RE_PHY_OLD[i]->read(), rat_spr[front_end_id][context_id][in_RENAME_NUM_REG_RE_LOG[i]->read()]);
		}

	    }
	}

      // Event
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  in_RENAME_VAL [i]->write(0);
	  in_INSERT_VAL [i]->write(0);
	}
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	in_RETIRE_VAL [i]->write(0);
      
      Tcontext_t retire_front_end_id [_param->_nb_inst_retire];
      Tcontext_t retire_context_id   [_param->_nb_inst_retire];
      
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  retire_front_end_id [i] = rand() % _param->_nb_front_end;
	  retire_context_id   [i] = rand() % (_param->_nb_context[retire_front_end_id [i]]);

	  for (uint32_t k=0; k<_param->_nb_general_register_logic; k++)
	    rat_gpr_updt [retire_front_end_id [i]][retire_context_id [i]][k] = false;
	  for (uint32_t k=0; k<_param->_nb_special_register_logic; k++)
	    rat_spr_updt [retire_front_end_id [i]][retire_context_id [i]][k] = false;
	}
      
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  in_RETIRE_VAL                [i]->write(1);
	  in_RETIRE_FRONT_END_ID       [i]->write(retire_front_end_id [i]);
	  in_RETIRE_CONTEXT_ID         [i]->write(retire_context_id   [i]);
	  in_RETIRE_EVENT_STATE        [i]->write(EVENT_STATE_EVENT);
	  in_RETIRE_WRITE_RD           [i]->write(0);
	  in_RETIRE_WRITE_RE           [i]->write(0);
	  
	  do
	    {
	      SC_START(1);
	    }
	  while (out_RETIRE_ACK[i]->read() == 0);
	  
	  in_RETIRE_VAL                [i]->write(0);
	}
      
      SC_START(1);

      nb_request = 32;
      while (nb_request > 1)
	{
	  
	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tcontrol_t val = (rand()%100)<percent_transaction_insert;
	      
	      Tcontext_t front_end_id = rand() % _param->_nb_front_end;

	      in_RENAME_VAL             [i]->write(val);
	      in_RENAME_FRONT_END_ID    [i]->write(front_end_id);
	      in_RENAME_CONTEXT_ID      [i]->write(rand() % (_param->_nb_context[front_end_id]));
	      in_RENAME_NUM_REG_RA_LOG  [i]->write(rand() % _param->_nb_general_register_logic);
	      in_RENAME_NUM_REG_RB_LOG  [i]->write(rand() % _param->_nb_general_register_logic);
	      in_RENAME_NUM_REG_RC_LOG  [i]->write(rand() % _param->_nb_special_register_logic);
	      in_RENAME_NUM_REG_RD_LOG  [i]->write(rand() % _param->_nb_general_register_logic);
	      in_RENAME_NUM_REG_RE_LOG  [i]->write(rand() % _param->_nb_special_register_logic);
	      in_INSERT_VAL             [i]->write(val);
	      in_INSERT_WRITE_RD        [i]->write(rand() % 2);
	      in_INSERT_WRITE_RE        [i]->write(rand() % 2);
	      in_INSERT_NUM_REG_RD_LOG  [i]->write(rand() % _param->_nb_general_register_logic);
	      in_INSERT_NUM_REG_RE_LOG  [i]->write(rand() % _param->_nb_special_register_logic);
	      in_INSERT_NUM_REG_RD_PHY  [i]->write(rand() % _param->_nb_general_register);
	      in_INSERT_NUM_REG_RE_PHY  [i]->write(rand() % _param->_nb_special_register);
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    {
	      Tcontrol_t val = (rand()%100)<percent_transaction_retire;
	      in_RETIRE_VAL                [i]->write(val);
	      in_RETIRE_FRONT_END_ID       [i]->write(retire_front_end_id [i]);
	      in_RETIRE_CONTEXT_ID         [i]->write(retire_context_id   [i]);
	      in_RETIRE_EVENT_STATE        [i]->write(EVENT_STATE_WAITEND);
	      in_RETIRE_WRITE_RD           [i]->write(rand() % 2);
	      in_RETIRE_WRITE_RE           [i]->write(rand() % 2);
	      in_RETIRE_NUM_REG_RD_LOG     [i]->write(rand() % _param->_nb_general_register_logic);
	      in_RETIRE_NUM_REG_RE_LOG     [i]->write(rand() % _param->_nb_special_register_logic);
	      in_RETIRE_NUM_REG_RD_PHY_OLD [i]->write(rand() % _param->_nb_general_register);
	      in_RETIRE_NUM_REG_RE_PHY_OLD [i]->write(rand() % _param->_nb_special_register);
	    }

	  SC_START(1);
	  

	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tcontext_t front_end_id = in_RENAME_FRONT_END_ID [i]->read();
	      Tcontext_t context_id   = in_RENAME_CONTEXT_ID   [i]->read();
	      if (in_INSERT_VAL [i]->read() and out_INSERT_ACK [i]->read())
		{
		  if (in_INSERT_WRITE_RD [i]->read() == 1)
		    rat_gpr[front_end_id][context_id][in_INSERT_NUM_REG_RD_LOG[i]->read()] = in_INSERT_NUM_REG_RD_PHY[i]->read();
		  if (in_INSERT_WRITE_RE [i]->read() == 1)
		    rat_spr[front_end_id][context_id][in_INSERT_NUM_REG_RE_LOG[i]->read()] = in_INSERT_NUM_REG_RE_PHY[i]->read();
		}
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    {
	      Tcontext_t front_end_id = in_RETIRE_FRONT_END_ID [i]->read();
	      Tcontext_t context_id   = in_RETIRE_CONTEXT_ID   [i]->read();
	      if (in_RETIRE_VAL [i]->read() and out_RETIRE_ACK [i]->read())
		{
		  if (in_RETIRE_WRITE_RD [i]->read() == 1)
		    {
		      if (rat_gpr_updt [front_end_id][context_id][in_RETIRE_NUM_REG_RD_LOG[i]->read()] == false)
			rat_gpr[front_end_id][context_id][in_RETIRE_NUM_REG_RD_LOG[i]->read()] = in_RETIRE_NUM_REG_RD_PHY_OLD[i]->read();
		      rat_gpr_updt [front_end_id][context_id][in_RETIRE_NUM_REG_RD_LOG[i]->read()] = true;
		    }
		  if (in_RETIRE_WRITE_RE [i]->read() == 1)
		    {
		      if (rat_spr_updt [front_end_id][context_id][in_RETIRE_NUM_REG_RE_LOG[i]->read()] == false)
			rat_spr[front_end_id][context_id][in_RETIRE_NUM_REG_RE_LOG[i]->read()] = in_RETIRE_NUM_REG_RE_PHY_OLD[i]->read();
		      rat_spr_updt [front_end_id][context_id][in_RETIRE_NUM_REG_RE_LOG[i]->read()] = true;
		    }
		}
	    }
	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tcontext_t front_end_id = in_RENAME_FRONT_END_ID [i]->read();
	      Tcontext_t context_id   = in_RENAME_CONTEXT_ID   [i]->read();
	      if (in_RENAME_VAL [i]->read() and out_RENAME_ACK [i]->read())
		{
		  nb_request --;

		  TEST(Tgeneral_address_t,out_RENAME_NUM_REG_RA_PHY    [i]->read(), rat_gpr[front_end_id][context_id][in_RENAME_NUM_REG_RA_LOG[i]->read()]);
		  TEST(Tgeneral_address_t,out_RENAME_NUM_REG_RB_PHY    [i]->read(), rat_gpr[front_end_id][context_id][in_RENAME_NUM_REG_RB_LOG[i]->read()]);
		  TEST(Tspecial_address_t,out_RENAME_NUM_REG_RC_PHY    [i]->read(), rat_spr[front_end_id][context_id][in_RENAME_NUM_REG_RC_LOG[i]->read()]);
		  TEST(Tgeneral_address_t,out_RENAME_NUM_REG_RD_PHY_OLD[i]->read(), rat_gpr[front_end_id][context_id][in_RENAME_NUM_REG_RD_LOG[i]->read()]);
		  TEST(Tspecial_address_t,out_RENAME_NUM_REG_RE_PHY_OLD[i]->read(), rat_spr[front_end_id][context_id][in_RENAME_NUM_REG_RE_LOG[i]->read()]);
		}

	    }
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_RENAME_VAL               ;
  delete [] out_RENAME_ACK               ;
  if (_param->_have_port_front_end_id)
  delete []  in_RENAME_FRONT_END_ID      ;
  if (_param->_have_port_context_id)
  delete []  in_RENAME_CONTEXT_ID        ;
  delete []  in_RENAME_NUM_REG_RA_LOG    ;
  delete []  in_RENAME_NUM_REG_RB_LOG    ;
  delete []  in_RENAME_NUM_REG_RC_LOG    ;
  delete []  in_RENAME_NUM_REG_RD_LOG    ;
  delete []  in_RENAME_NUM_REG_RE_LOG    ;
  delete [] out_RENAME_NUM_REG_RA_PHY    ;
  delete [] out_RENAME_NUM_REG_RB_PHY    ;
  delete [] out_RENAME_NUM_REG_RC_PHY    ;
  delete [] out_RENAME_NUM_REG_RD_PHY_OLD;
  delete [] out_RENAME_NUM_REG_RE_PHY_OLD;

  delete []  in_INSERT_VAL               ;
  delete [] out_INSERT_ACK               ;
//if (_param->_have_port_front_end_id)
//delete []  in_INSERT_FRONT_END_ID      ;
//if (_param->_have_port_context_id)
//delete []  in_INSERT_CONTEXT_ID        ;
  delete []  in_INSERT_WRITE_RD          ;
  delete []  in_INSERT_WRITE_RE          ;
  delete []  in_INSERT_NUM_REG_RD_LOG    ;
  delete []  in_INSERT_NUM_REG_RE_LOG    ;
  delete []  in_INSERT_NUM_REG_RD_PHY    ;
  delete []  in_INSERT_NUM_REG_RE_PHY    ;

  delete []  in_RETIRE_VAL               ;
  delete [] out_RETIRE_ACK               ;
  if (_param->_have_port_front_end_id)
  delete []  in_RETIRE_FRONT_END_ID      ;
  if (_param->_have_port_context_id)
  delete []  in_RETIRE_CONTEXT_ID        ;
  delete []  in_RETIRE_EVENT_STATE       ;
  delete []  in_RETIRE_WRITE_RD          ;
  delete []  in_RETIRE_WRITE_RE          ;
  delete []  in_RETIRE_NUM_REG_RD_LOG    ;
  delete []  in_RETIRE_NUM_REG_RE_LOG    ;
  delete []  in_RETIRE_NUM_REG_RD_PHY_OLD;
  delete []  in_RETIRE_NUM_REG_RE_PHY_OLD;

#endif

  delete _Register_Address_Translation_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
