#include "../include/Cache_OneLevel.h"

namespace environnement {
namespace cache {
namespace cache_onelevel {

  // If a instruction is in the write_buffer, return the position
  // else, return the number of elt in the write_buffer
  uint32_t Cache_OneLevel::hit_write_buffer (uint32_t trdid, Address address)
  {
    uint32_t num_write_buffer = 0;
    // Scan the write_buffer
    for (num_write_buffer = 0; num_write_buffer < write_buffer->nb_slot_use(); num_write_buffer ++)
      {
	queue::slot_t<Write_Buffer> val = write_buffer->read(num_write_buffer);
	
	if ( (val._data.trdid           == trdid          ) &&
	     (val._data.address.tag     == address.tag    ) &&
	     (val._data.address.familly == address.familly))
	  break;
      }
    
    return num_write_buffer;
  }

};
};
};
