/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Read_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit::deallocation"
  void Read_unit::deallocation (void)
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete     in_CLOCK ;
	delete     in_NRESET;

	// ~~~~~[ Interface "read_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete     in_READ_UNIT_IN_VAL                  ;
	delete    out_READ_UNIT_IN_ACK                  ;
	if (_param->_have_port_context_id)
	delete     in_READ_UNIT_IN_CONTEXT_ID           ;
	if (_param->_have_port_front_end_id)
	delete     in_READ_UNIT_IN_FRONT_END_ID         ;
	if (_param->_have_port_ooo_engine_id)
	delete     in_READ_UNIT_IN_OOO_ENGINE_ID        ;
	if (_param->_have_port_packet_id)
	delete     in_READ_UNIT_IN_PACKET_ID            ;
	delete     in_READ_UNIT_IN_OPERATION            ;
	delete     in_READ_UNIT_IN_TYPE                 ;
	delete     in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE;
	if (_param->_have_port_load_queue_ptr)
	delete     in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE ;
	delete     in_READ_UNIT_IN_HAS_IMMEDIAT         ;
	delete     in_READ_UNIT_IN_IMMEDIAT             ;
	delete     in_READ_UNIT_IN_READ_RA              ;
	delete     in_READ_UNIT_IN_NUM_REG_RA           ;
	delete     in_READ_UNIT_IN_READ_RB              ;
	delete     in_READ_UNIT_IN_NUM_REG_RB           ;
	delete     in_READ_UNIT_IN_READ_RC              ;
	delete     in_READ_UNIT_IN_NUM_REG_RC           ;
	delete     in_READ_UNIT_IN_WRITE_RD             ;
	delete     in_READ_UNIT_IN_NUM_REG_RD           ;
	delete     in_READ_UNIT_IN_WRITE_RE             ;
	delete     in_READ_UNIT_IN_NUM_REG_RE           ;

	// ~~~~~[ Interface "read_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete [] out_READ_UNIT_OUT_VAL                  ;
	delete []  in_READ_UNIT_OUT_ACK                  ;
	if (_param->_have_port_context_id)
	delete [] out_READ_UNIT_OUT_CONTEXT_ID           ;
	if (_param->_have_port_front_end_id)
	delete [] out_READ_UNIT_OUT_FRONT_END_ID         ;
	if (_param->_have_port_ooo_engine_id)
	delete [] out_READ_UNIT_OUT_OOO_ENGINE_ID        ;
	if (_param->_have_port_packet_id)
	delete [] out_READ_UNIT_OUT_PACKET_ID            ;
	delete [] out_READ_UNIT_OUT_OPERATION            ;
	delete [] out_READ_UNIT_OUT_TYPE                 ;
	delete [] out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE;
	if (_param->_have_port_load_queue_ptr)
	delete [] out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ;
	delete [] out_READ_UNIT_OUT_HAS_IMMEDIAT         ;
	delete [] out_READ_UNIT_OUT_IMMEDIAT             ;
	delete [] out_READ_UNIT_OUT_DATA_RA              ;
	delete [] out_READ_UNIT_OUT_DATA_RB              ;
	delete [] out_READ_UNIT_OUT_DATA_RC              ;
	delete [] out_READ_UNIT_OUT_WRITE_RD             ;
	delete [] out_READ_UNIT_OUT_NUM_REG_RD           ;
	delete [] out_READ_UNIT_OUT_WRITE_RE             ;
	delete [] out_READ_UNIT_OUT_NUM_REG_RE           ;

	// ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete [] out_GPR_READ_VAL          ;
	delete []  in_GPR_READ_ACK          ;
	if (_param->_have_port_ooo_engine_id)
	delete [] out_GPR_READ_OOO_ENGINE_ID;
	delete [] out_GPR_READ_NUM_REG      ;
	delete []  in_GPR_READ_DATA         ;
	delete []  in_GPR_READ_DATA_VAL     ;

	// ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete [] out_SPR_READ_VAL          ;
	delete []  in_SPR_READ_ACK          ;
	if (_param->_have_port_ooo_engine_id)
	delete [] out_SPR_READ_OOO_ENGINE_ID;
	delete [] out_SPR_READ_NUM_REG      ;
	delete []  in_SPR_READ_DATA         ;
	delete []  in_SPR_READ_DATA_VAL     ;

	// ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_GPR_WRITE_VAL          ;
	if (_param->_have_port_ooo_engine_id)
	delete []  in_GPR_WRITE_OOO_ENGINE_ID;
	delete []  in_GPR_WRITE_NUM_REG      ;
	delete []  in_GPR_WRITE_DATA         ;

	// ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_SPR_WRITE_VAL          ;
	if (_param->_have_port_ooo_engine_id)
	delete []  in_SPR_WRITE_OOO_ENGINE_ID;
	delete []  in_SPR_WRITE_NUM_REG      ;
	delete []  in_SPR_WRITE_DATA         ;

	// ~~~~~[ Interface "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	if (_param->_have_port_ooo_engine_id)
	delete []  in_BYPASS_WRITE_OOO_ENGINE_ID ;
	delete []  in_BYPASS_WRITE_GPR_VAL       ;
	delete []  in_BYPASS_WRITE_GPR_NUM_REG   ;
	delete []  in_BYPASS_WRITE_GPR_DATA      ;
	delete []  in_BYPASS_WRITE_SPR_VAL       ;
	delete []  in_BYPASS_WRITE_SPR_NUM_REG   ;
	delete []  in_BYPASS_WRITE_SPR_DATA      ;

	// ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_BYPASS_MEMORY_VAL          ;
	if (_param->_have_port_ooo_engine_id)
	delete []  in_BYPASS_MEMORY_OOO_ENGINE_ID;
	delete []  in_BYPASS_MEMORY_NUM_REG      ;
	delete []  in_BYPASS_MEMORY_DATA         ;
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component_read_queue;
    delete _component_reservation_station;
    delete _component;

    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
