#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_network_execution_unit_to_write_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_network_execution_unit_to_write_unit_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Behavioural/include/Types.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Identification.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t    _nb_execute_unit              ;
  public : const uint32_t    _nb_write_unit                ;
  public : const uint32_t    _nb_context                   ;
  public : const uint32_t    _nb_front_end                 ;
  public : const uint32_t    _nb_ooo_engine                ;
  public : const uint32_t    _nb_packet                    ;
  public : const uint32_t    _size_general_data            ;
  public : const uint32_t    _size_special_data            ;
  public : const uint32_t    _nb_general_register          ;
  public : const uint32_t    _nb_special_register          ;
  public : const Tpriority_t _priority                     ;
  public :       bool     ** _table_routing                ; //array [nb_execute_unit][nb_write_unit]
  public :       bool     ** _table_thread                 ; //array [nb_write_unit][nb_thread]

  public : const uint32_t    _size_context_id              ;
  public : const uint32_t    _size_front_end_id            ;
  public : const uint32_t    _size_ooo_engine_id           ;
  public : const uint32_t    _size_packet_id               ;
  public : const uint32_t    _size_general_register        ;
  public : const uint32_t    _size_special_register        ;

  public : const bool        _have_port_context_id         ;
  public : const bool        _have_port_front_end_id       ;
  public : const bool        _have_port_ooo_engine_id      ;
  public : const bool        _have_port_packet_id          ;

  public : const uint32_t    _nb_thread                    ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    nb_execute_unit              ,
			uint32_t    nb_write_unit                ,
			uint32_t    nb_context                   ,
			uint32_t    nb_front_end                 ,
			uint32_t    nb_ooo_engine                ,
			uint32_t    nb_packet                    ,
			uint32_t    size_general_data            ,
			uint32_t    size_special_data            ,
			uint32_t    nb_general_register          ,
			uint32_t    nb_special_register          ,
			Tpriority_t priority                     ,
			bool     ** table_routing                ,
			bool     ** table_thread                 );
  public : Parameters  (Parameters & param) ;
  public : ~Parameters ();

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::Parameters & x);
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
