#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::transition"
  void Decod::transition (void)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	reg_CONTEXT_PRIORITY = 0;

	for (uint32_t i=0; i<_param->_nb_context; i++)
	  reg_CONTEXT_ADDRESS_PREVIOUS [i] = 0xfc; // 0x100-4. (0x100 : reset address)
      }
    else
      {
	switch (_param->_priority)
	  {
// 	  case PRIORITY_STATIC :
// 	    {
// 	      reg_CONTEXT_PRIORITY = (reg_CONTEXT_PRIORITY+_param->_nb_context_select)%_param->_nb_context;
// 	      break;
// 	    }
	  case PRIORITY_ROUND_ROBIN :
	    {
	      reg_CONTEXT_PRIORITY = (reg_CONTEXT_PRIORITY+1                         )%_param->_nb_context;
	      break;
	    }
	  default:
	    {
	      break;
	    }
	  }

	// flush list
	select.clear();
	
	// Compute next scan order !!!
	switch (_param->_load_balancing)
	  {
// 	  case LOAD_BALANCING_BALANCE :
// 	    {
// 	      for (uint32_t j=0; j<_param->_max_nb_inst_fetch; j++)
// 		for (uint32_t i=0; i<_param->_nb_context_select; i++)
// 		  {
// 		    uint32_t x=(reg_CONTEXT_PRIORITY+i)%_param->_nb_context;
		    
// 		    // Test valid inst_fetch
// 		    if (j < _param->_nb_inst_fetch[x])
// 		      select.push_back(select_t(x,j));
// 		  }
		  
// 	      break;
// 	    }
	  case LOAD_BALANCING_MAXIMUM_FOR_PRIORITY :
	    {

	      for (uint32_t i=0; i<_param->_nb_context_select; i++)
		{
		  uint32_t x=(reg_CONTEXT_PRIORITY+i)%_param->_nb_context;
		  
		  for (uint32_t j=0; j<_param->_nb_inst_fetch[x]; j++)
		    select.push_back(select_t(x,j));
		}

	      break;
	    }
	  default :
	    {
	      break;
	    }
	  }

	// Compute "next previous" address
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  if (internal_CONTEXT_HAVE_TRANSACTION[i])
	    {
	      reg_CONTEXT_ADDRESS_PREVIOUS [i] = internal_CONTEXT_ADDRESS_PREVIOUS [i];
	      reg_CONTEXT_IS_DELAY_SLOT    [i] = internal_CONTEXT_IS_DELAY_SLOT    [i];
	    }

// 	for (uint32_t i=0; i<_param->_nb_context; i++)
// 	  log_printf(TRACE,Decod,FUNCTION,"[%d] %.8x %d",i,reg_CONTEXT_ADDRESS_PREVIOUS [i], reg_CONTEXT_IS_DELAY_SLOT [i]);
      }

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
