/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#define LABEL(str...)							\
  {									\
    msg (_("{%d} "),static_cast<uint32_t>(sc_simulation_time()));	\
    msg (str);								\
    msg (_("\n"));							\
  } while(0)

#define SC_START(cycle_offset)                                                       \
  do									             \
    {									             \
      /*cout << "SC_START (begin)" << endl;*/				             \
									             \
      uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time());          \
      if (cycle_offset != 0)						             \
	{								             \
	  cout << "##########[ cycle "<< cycle_current+cycle_offset << " ]" << endl; \
	}								             \
									             \
      if (cycle_current > CYCLE_MAX)					             \
	{								             \
	  TEST_KO("Maximal cycles Reached");				             \
	}								             \
									             \
      sc_start(cycle_offset);						             \
									             \
      /*cout << "SC_START (end  )" << endl;*/				             \
    } while(0)

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::free_list_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Free_List_unit * _Free_List_unit = new Free_List_unit (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_POP_VAL         ," in_POP_VAL         ",Tcontrol_t        ,_param->_nb_pop );
  ALLOC1_SC_SIGNAL(out_POP_ACK         ,"out_POP_ACK         ",Tcontrol_t        ,_param->_nb_pop );
  ALLOC1_SC_SIGNAL( in_POP_GPR_VAL     ," in_POP_GPR_VAL     ",Tcontrol_t        ,_param->_nb_pop );
  ALLOC1_SC_SIGNAL(out_POP_GPR_NUM_REG ,"out_POP_GPR_NUM_REG ",Tgeneral_address_t,_param->_nb_pop );
  ALLOC1_SC_SIGNAL( in_POP_SPR_VAL     ," in_POP_SPR_VAL     ",Tcontrol_t        ,_param->_nb_pop );
  ALLOC1_SC_SIGNAL(out_POP_SPR_NUM_REG ,"out_POP_SPR_NUM_REG ",Tspecial_address_t,_param->_nb_pop );
  ALLOC1_SC_SIGNAL( in_PUSH_GPR_VAL    ," in_PUSH_GPR_VAL    ",Tcontrol_t        ,_param->_nb_push);
  ALLOC1_SC_SIGNAL(out_PUSH_GPR_ACK    ,"out_PUSH_GPR_ACK    ",Tcontrol_t        ,_param->_nb_push);
  ALLOC1_SC_SIGNAL( in_PUSH_GPR_NUM_REG," in_PUSH_GPR_NUM_REG",Tgeneral_address_t,_param->_nb_push);
  ALLOC1_SC_SIGNAL( in_PUSH_SPR_VAL    ," in_PUSH_SPR_VAL    ",Tcontrol_t        ,_param->_nb_push);
  ALLOC1_SC_SIGNAL(out_PUSH_SPR_ACK    ,"out_PUSH_SPR_ACK    ",Tcontrol_t        ,_param->_nb_push);
  ALLOC1_SC_SIGNAL( in_PUSH_SPR_NUM_REG," in_PUSH_SPR_NUM_REG",Tspecial_address_t,_param->_nb_push);
    
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Free_List_unit.\n"),name.c_str());

  (*(_Free_List_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Free_List_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Free_List_unit, in_POP_VAL         ,_param->_nb_pop );
  INSTANCE1_SC_SIGNAL(_Free_List_unit,out_POP_ACK         ,_param->_nb_pop );
  INSTANCE1_SC_SIGNAL(_Free_List_unit, in_POP_GPR_VAL     ,_param->_nb_pop );
  INSTANCE1_SC_SIGNAL(_Free_List_unit,out_POP_GPR_NUM_REG ,_param->_nb_pop );
  INSTANCE1_SC_SIGNAL(_Free_List_unit, in_POP_SPR_VAL     ,_param->_nb_pop );
  INSTANCE1_SC_SIGNAL(_Free_List_unit,out_POP_SPR_NUM_REG ,_param->_nb_pop );
  INSTANCE1_SC_SIGNAL(_Free_List_unit, in_PUSH_GPR_VAL    ,_param->_nb_push);
  INSTANCE1_SC_SIGNAL(_Free_List_unit,out_PUSH_GPR_ACK    ,_param->_nb_push);
  INSTANCE1_SC_SIGNAL(_Free_List_unit, in_PUSH_GPR_NUM_REG,_param->_nb_push);
  INSTANCE1_SC_SIGNAL(_Free_List_unit, in_PUSH_SPR_VAL    ,_param->_nb_push);
  INSTANCE1_SC_SIGNAL(_Free_List_unit,out_PUSH_SPR_ACK    ,_param->_nb_push);
  INSTANCE1_SC_SIGNAL(_Free_List_unit, in_PUSH_SPR_NUM_REG,_param->_nb_push);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_pop  = 75;
  const  int32_t percent_transaction_push = 75;

  bool gpr_free [_param->_nb_general_register];
  bool spr_free [_param->_nb_general_register];

  for (uint32_t i=0; i<_param->_nb_general_register; i++)
    gpr_free [i] = false;
  for (uint32_t i=0; i<_param->_nb_special_register; i++)
    spr_free [i] = false;

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

      
  LABEL("After reset all free-list is empty");

  // Test GPR
  for (uint32_t i=0; i<_param->_nb_pop; i++)
    {
      in_POP_GPR_VAL [i]->write(1);
    }
  SC_START(0);

  for (uint32_t i=0; i<_param->_nb_pop; i++)
    TEST(Tcontrol_t, out_POP_ACK[i]->read(), false);

  // Test SPR
  for (uint32_t i=0; i<_param->_nb_pop; i++)
    {
      in_POP_GPR_VAL [i]->write(0);
      in_POP_SPR_VAL [i]->write(1);
    }
  SC_START(0);

  for (uint32_t i=0; i<_param->_nb_pop; i++)
    TEST(Tcontrol_t, out_POP_ACK[i]->read(), false);

  // Reset val
  for (uint32_t i=0; i<_param->_nb_pop; i++)
    {
      in_POP_GPR_VAL [i]->write(0);
      in_POP_SPR_VAL [i]->write(0);
    }

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      int32_t nb_request = 32;

      while (nb_request > 1)
	{
	  for (uint32_t i=0; i<_param->_nb_push; i++)
	    {
	      Tgeneral_address_t gpr_reg = rand()%_param->_nb_general_register;
	      in_PUSH_GPR_VAL     [i]->write(not gpr_free[gpr_reg] and ((rand()%100)<percent_transaction_push));
	      in_PUSH_GPR_NUM_REG [i]->write(gpr_reg);
	      
	      Tspecial_address_t spr_reg = rand()%_param->_nb_special_register;
	      in_PUSH_SPR_VAL     [i]->write(not spr_free[spr_reg] and ((rand()%100)<percent_transaction_push));
	      in_PUSH_SPR_NUM_REG [i]->write(spr_reg);
	    }
	  
	  for (uint32_t i=0; i<_param->_nb_pop; i++)
	    {
	      in_POP_VAL     [i]->write((rand()%100)<percent_transaction_pop);
	      in_POP_GPR_VAL [i]->write(rand()%2);
	      in_POP_SPR_VAL [i]->write(rand()%2);
	    }
	  
	  SC_START(0);
	  
	  for (uint32_t i=0; i<_param->_nb_pop; i++)
	    if (in_POP_VAL [i]->read() and out_POP_ACK[i]->read())
	      {
		nb_request --;
		if (in_POP_GPR_VAL [i]->read())
		  {
		    Tgeneral_address_t reg = out_POP_GPR_NUM_REG [i]->read();
		    
		    TEST(bool, gpr_free[reg],true);

		    Tgeneral_address_t bank = reg >> _param->_bank_gpr_size_slot;
		    TEST(bool, (bank >= (i*_param->_nb_bank_by_pop)) and (bank < ((i+1)*_param->_nb_bank_by_pop)), true);

		    gpr_free[reg] = false;
		  }
		
		if (in_POP_SPR_VAL [i]->read())
		  {
		    Tspecial_address_t reg = out_POP_SPR_NUM_REG [i]->read();
		    
		    TEST(bool,spr_free[reg],true);
		    
		    Tspecial_address_t bank = reg >> _param->_bank_spr_size_slot;
		    TEST(bool, (bank >= (i*_param->_nb_bank_by_pop)) and (bank < ((i+1)*_param->_nb_bank_by_pop)), true);

		    spr_free[reg] = false;
		  }
	      }
	  
	  for (uint32_t i=0; i<_param->_nb_push; i++)
	    {
	      if (in_PUSH_GPR_VAL [i]->read() and out_PUSH_GPR_ACK [i]->read())
		gpr_free[in_PUSH_GPR_NUM_REG [i]->read()] = true;
	      if (in_PUSH_SPR_VAL [i]->read() and out_PUSH_SPR_ACK [i]->read())
		spr_free[in_PUSH_SPR_NUM_REG [i]->read()] = true;
	    }
	  SC_START(1);
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_POP_VAL         ;
  delete [] out_POP_ACK         ;
  delete []  in_POP_GPR_VAL     ;
  delete [] out_POP_GPR_NUM_REG ;
  delete []  in_POP_SPR_VAL     ;
  delete [] out_POP_SPR_NUM_REG ;
  delete []  in_PUSH_GPR_VAL    ;
  delete [] out_PUSH_GPR_ACK    ;
  delete []  in_PUSH_GPR_NUM_REG;
  delete []  in_PUSH_SPR_VAL    ;
  delete [] out_PUSH_SPR_ACK    ;
  delete []  in_PUSH_SPR_NUM_REG;
#endif

  delete _Free_List_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
