/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Generic/Sort/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace sort {


#undef  FUNCTION
#define FUNCTION "Sort::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

    Parameters_test test ("Sort");

    // Test if param : n ==  2^k
    if (is_positive(log2(_nb_input)) == false)
      test.error("nb_input is not a power of 2.");

    // Test functionnal
    if (_nb_input < _nb_output)
      test.error("nb_input must be higher than nb_output.");

    if (is_between_exclusive (_size_data,0 ,(8*sizeof(Tdata_t))) == false)
      test.error("type \"Tdata_t\" is too little to the size defined by size_data.");

    if (is_between_exclusive (static_cast<uint32_t>(log2(_nb_input)),0 ,(8*sizeof(Taddress_t))) == false)
      test.error("type \"Taddress_t\" is too little to the size defined by nb_input.");

    if ((not _have_port_index_out) and (not _have_port_data_out))
      test.error("Need ouput : index, data (sorted) or both.");

    if (not _ascending)
      test.error("descending order not supported. (Coming Soon)");

    log_printf(FUNC,Sort,FUNCTION,"End");

    return test;
  };

}; // end namespace sort
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
