/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Sort/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace sort {


#undef  FUNCTION
#define FUNCTION "Sort::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

    XML xml ("sort");

    xml.balise_open("sort");
    xml.singleton_begin("nb_input           "); xml.attribut("value",toString(_nb_input           )); xml.singleton_end();
    xml.singleton_begin("nb_output          "); xml.attribut("value",toString(_nb_output          )); xml.singleton_end();
    xml.singleton_begin("ascending          "); xml.attribut("value",toString(_ascending          )); xml.singleton_end();
    xml.singleton_begin("size_data          "); xml.attribut("value",toString(_size_data          )); xml.singleton_end();
    xml.singleton_begin("have_port_index_out"); xml.attribut("value",toString(_have_port_index_out)); xml.singleton_end();
    xml.singleton_begin("have_port_data_out "); xml.attribut("value",toString(_have_port_data_out )); xml.singleton_end();
    xml.balise_close();

    log_printf(FUNC,Sort,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Sort::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::generic::sort::Parameters & x)
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Sort,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace sort
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
