/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Sort/include/Sort.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace sort {



#undef  FUNCTION
#define FUNCTION "Sort::allocation"
  void Sort::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Sort"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "input" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("input", IN, WEST, "List of data unsort",_param->_nb_input);

      ALLOC1_SIGNAL_IN(in_INPUT_VAL ,"val" , Tcontrol_t, 1);
      ALLOC1_SIGNAL_IN(in_INPUT_DATA,"data", Tdata_t   , _param->_size_data);
    }

    // ~~~~~[ Interface : "output" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("output",OUT, EAST, "List of data sort",_param->_nb_output);

      ALLOC1_SIGNAL_OUT(out_OUTPUT_VAL  ,"val"  ,Tcontrol_t,1);
      if (_param->_have_port_index_out)
      ALLOC1_SIGNAL_OUT(out_OUTPUT_INDEX,"index",Taddress_t,_param->_size_address);
      if (_param->_have_port_data_out)
      ALLOC1_SIGNAL_OUT(out_OUTPUT_DATA ,"data" ,Tdata_t   ,_param->_size_data   );
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Sort,FUNCTION,"End");
  };

}; // end namespace sort
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
