/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Parameters.h"
#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Types.h"
#include <sstream>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  Parameters_test Parameters::msg_error(void)
  {
    Parameters_test test ("Victime_Pseudo_LRU");

    if (_nb_entity < 2)
      test.error("nb_entity must be >= 2");
    
    if (is_positive(log2(_nb_entity)) == false)
      test.error("nb_entity is not a power of 2");

    if (_nb_access <  1)
      test.error("nb_access must be >= 1");

    if (_size_table < 1)
      test.error("size_table must be >= 1");

    if (is_between_inclusive (static_cast<uint32_t>(log2(_nb_entity)),0 ,(8*sizeof(Tentity_t))) == false)
      test.error("type \"Tentity_t\" is too little to the size defined by nb_entity");

    if (is_between_inclusive (static_cast<uint32_t>(log2(_size_table)),0 ,(8*sizeof(Taddress_t))) == false)
      test.error("type \"Taddress_t\" is too little to the size defined by size_table");

    return test;
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
