#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::transition"
  void Free_List_unit::transition (void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	internal_BANK_PRIORITY = 0;
	for (uint32_t i=0; i<_param->_nb_bank; i++)
	  {
	    _gpr_list[i].clear();
	    _spr_list[i].clear();
	  }
      }
    else
      {
	// ==================================================
	// =====[ POP ]======================================
	// ==================================================
// 	log_printf(TRACE,Free_List_unit,FUNCTION,"Test transaction POP");
	for (uint32_t i=0; i<_param->_nb_pop; i++)
	  if (PORT_READ(in_POP_VAL[i]) and internal_POP_ACK [i])
	    {
	      if (PORT_READ(in_POP_GPR_VAL [i]))
		_gpr_list [internal_POP_GPR_BANK[i]].pop_front();
	 
	      if (PORT_READ(in_POP_SPR_VAL [i]))
		_spr_list [internal_POP_SPR_BANK[i]].pop_front();
	    }

	// ==================================================
	// =====[ PUSH_GPR ]=================================
	// ==================================================
// 	log_printf(TRACE,Free_List_unit,FUNCTION,"Test transaction PUSH_GPR");
	for (uint32_t i=0; i<_param->_nb_push; i++)
	  if (PORT_READ(in_PUSH_GPR_VAL[i]) and internal_PUSH_GPR_ACK [i])
	    _gpr_list [internal_PUSH_GPR_BANK[i]].push_back(//_param->_mask_gpr &
							    PORT_READ(in_PUSH_GPR_NUM_REG [i]));

	// ==================================================
	// =====[ PUSH_SPR ]=================================
	// ==================================================
// 	log_printf(TRACE,Free_List_unit,FUNCTION,"Test transaction PUSH_SPR");
	for (uint32_t i=0; i<_param->_nb_push; i++)
	  if (PORT_READ(in_PUSH_SPR_VAL[i]) and internal_PUSH_SPR_ACK [i])
	    _spr_list [internal_PUSH_SPR_BANK[i]].push_back(//_param->_mask_spr &
							    PORT_READ(in_PUSH_SPR_NUM_REG [i]));

	if (_param->_priority == PRIORITY_ROUND_ROBIN)
	  internal_BANK_PRIORITY = (internal_BANK_PRIORITY+1)%_param->_nb_bank_by_pop;
      }

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
