/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"

namespace morpheo              {
namespace behavioural          {

  Signal::Signal  (std::string          name         ,
		   direction_t     direction    ,
		   uint32_t        size         ,
		   presence_port_t presence_port):
    _name          (name         ),
    _direction     (direction    ),
    _presence_port ((direction==INTERNAL)?PORT_VHDL_NO_TESTBENCH_NO:presence_port)
  {
    log_printf(FUNC,Behavioural,"Signal","Begin");
    _size                     = size;
    _is_allocate              = false;
    _is_map_as_component_src  = false;
    _is_map_as_component_dest = false;
    _is_map_as_toplevel_dest  = false;
    _connect_from_signal      = NULL;
    _connect_to_signal        = NULL;
    _sc_signal                = NULL;
    _sc_signal_map            = NULL;
    _type_info                = UNKNOW;
#ifdef VHDL_TESTBENCH
    _list_value          = new std::list<std::string>;
#endif
    
    if (_size == 0)
      throw ERRORMORPHEO(FUNCTION,"Size of signal '"+_name+"' is nul");


    log_printf(FUNC,Behavioural,"Signal","End");
  };

  Signal::Signal  (const Signal & signal):
    _name          (signal._name         ),
    _direction     (signal._direction    ),
    _presence_port (signal._presence_port)
  {
    log_printf(FUNC,Behavioural,"Signal (copy)","Begin");
    _size                     = signal._size;
    _is_allocate              = signal._is_allocate;
    _is_map_as_component_src  = signal._is_map_as_component_src ;
    _is_map_as_component_dest = signal._is_map_as_component_dest;
    _is_map_as_toplevel_dest  = signal._is_map_as_component_dest;
    _connect_from_signal      = signal._connect_from_signal;
    _connect_to_signal        = signal._connect_to_signal;
    _sc_signal                = signal._sc_signal    ;
    _sc_signal_map            = signal._sc_signal_map;
    _type_info                = signal._type_info ;
#ifdef VHDL_TESTBENCH
    _list_value               = signal._list_value;
#endif
    log_printf(FUNC,Behavioural,"Signal (copy)","End");
  };

  Signal::~Signal ()
  {
    log_printf(FUNC,Behavioural,"~Signal","Begin");

//     if (_is_allocate == true)
//       switch (_direction)
// 	{
// 	case IN : 
// 	  {
// 	    switch (_type_info)
// 	      {
// 	      case BOOL     : {delete (static_cast<sc_in  <bool    > *>(_sc_signal)); break;}
// 	      case UINT8_T  : {delete (static_cast<sc_in  <uint8_t > *>(_sc_signal)); break;}
// 	      case UINT16_T : {delete (static_cast<sc_in  <uint16_t> *>(_sc_signal)); break;}
// 	      case UINT32_T : {delete (static_cast<sc_in  <uint32_t> *>(_sc_signal)); break;}
// 	      case UINT64_T : {delete (static_cast<sc_in  <uint64_t> *>(_sc_signal)); break;}
// 	      default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow.")); break;}
// 	      }
// 	    break;
// 	  }
// 	case OUT : 
// 	  {
// 	    switch (_type_info)
// 	      {
// 	      case BOOL     : {delete (static_cast<sc_out <bool    > *>(_sc_signal)); break;}
// 	      case UINT8_T  : {delete (static_cast<sc_out <uint8_t > *>(_sc_signal)); break;}
// 	      case UINT16_T : {delete (static_cast<sc_out <uint16_t> *>(_sc_signal)); break;}
// 	      case UINT32_T : {delete (static_cast<sc_out <uint32_t> *>(_sc_signal)); break;}
// 	      case UINT64_T : {delete (static_cast<sc_out <uint64_t> *>(_sc_signal)); break;}
// 	      default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow.")); break;}
// 	      }
// 	    break;
// 	  }
// 	case INTERNAL : 
// 	  {
// 	    switch (_type_info)
// 	      {
// 	      case BOOL     : {delete (static_cast<sc_sc_signal <bool    > *>(_sc_signal)); break;}
// 	      case UINT8_T  : {delete (static_cast<sc_sc_signal <uint8_t > *>(_sc_signal)); break;}
// 	      case UINT16_T : {delete (static_cast<sc_sc_signal <uint16_t> *>(_sc_signal)); break;}
// 	      case UINT32_T : {delete (static_cast<sc_sc_signal <uint32_t> *>(_sc_signal)); break;}
// 	      case UINT64_T : {delete (static_cast<sc_sc_signal <uint64_t> *>(_sc_signal)); break;}
// 	      default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow.")); break;}
// 	      }
// 	    break;
// 	  }
// 	default       : {throw (ErrorMorpheo ("Signal \""+_name+"\" : direction unknow.")); break;}
// 	}

#ifdef VHDL_TESTBENCH
    delete _list_value;
#endif
    log_printf(FUNC,Behavioural,"~Signal","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
