/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {



#undef  FUNCTION
#define FUNCTION "Ifetch_queue::allocation"
  void Ifetch_queue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Ifetch_queue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "address" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC_INTERFACE("address", IN, NORTH, "Transaction with PC management.");

      ALLOC_VALACK_IN ( in_ADDRESS_VAL                        ,VAL);
      ALLOC_VALACK_OUT(out_ADDRESS_ACK                        ,ACK);
      ALLOC_SIGNAL_IN ( in_ADDRESS_INSTRUCTION_ADDRESS        ,"instruction_address"        ,Tgeneral_address_t ,_param->_size_general_data            );
      ALLOC_SIGNAL_IN ( in_ADDRESS_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t ,_param->_size_instruction_ptr         );
      ALLOC_SIGNAL_IN ( in_ADDRESS_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state            );
      ALLOC_SIGNAL_IN ( in_ADDRESS_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_branch_update_prediction);
      ALLOC_SIGNAL_OUT(out_ADDRESS_IFETCH_QUEUE_ID            ,"ifetch_queue_id"            ,Tifetch_queue_ptr_t,_param->_size_queue_ptr               );

    }
    {
      ALLOC1_INTERFACE("address", IN, NORTH, "Transaction with PC management.",_param->_nb_instruction);

      ALLOC1_SIGNAL_IN( in_ADDRESS_INSTRUCTION_ENABLE         ,"instruction_enable"         ,Tcontrol_t         ,1);
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("decod",OUT, EAST, "Send instruction bundle to the decod's stage.",_param->_nb_instruction);
      
      ALLOC1_VALACK_OUT(out_DECOD_VAL        ,VAL);
      ALLOC1_VALACK_IN ( in_DECOD_ACK        ,ACK);
      ALLOC1_SIGNAL_OUT(out_DECOD_INSTRUCTION,"instruction",Tinstruction_t,_param->_size_instruction);
    }
    {
      ALLOC_INTERFACE("decod",OUT, EAST, "Send instruction bundle to the decod's stage.");
      
      ALLOC_SIGNAL_OUT(out_DECOD_ADDRESS                    ,"address"                    ,Tgeneral_address_t,_param->_size_general_data            );
      ALLOC_SIGNAL_OUT(out_DECOD_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t,_param->_size_instruction_ptr         );
      ALLOC_SIGNAL_OUT(out_DECOD_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t   ,_param->_size_branch_state            );
      ALLOC_SIGNAL_OUT(out_DECOD_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t ,_param->_size_branch_update_prediction);
      ALLOC_SIGNAL_OUT(out_DECOD_EXCEPTION                  ,"exception"                  ,Texception_t      ,_param->_size_exception_ifetch        );
    }

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC_INTERFACE("icache_rsp", IN, WEST, "Respons from Instruction Cache.");
      
      ALLOC_VALACK_IN ( in_ICACHE_RSP_VAL      ,VAL);
      ALLOC_VALACK_OUT(out_ICACHE_RSP_ACK      ,ACK);
      ALLOC_SIGNAL_IN ( in_ICACHE_RSP_PACKET_ID,"packet_id",Tpacket_t      ,_param->_size_queue_ptr   );
      ALLOC_SIGNAL_IN ( in_ICACHE_RSP_ERROR    ,"error"    ,Ticache_error_t,_param->_size_icache_error);
    }
    {
      ALLOC1_INTERFACE("icache_rsp", IN, WEST, "Respons from Instruction Cache.",_param->_nb_instruction);
      
      ALLOC1_SIGNAL_IN ( in_ICACHE_RSP_INSTRUCTION,"instruction",Ticache_instruction_t,_param->_size_instruction);
    }

    // ~~~~~[ Interface "event_reset" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC_INTERFACE("event_reset", IN, NORTH, "An event occure and reset queue.");

      ALLOC_VALACK_IN ( in_EVENT_RESET_VAL,VAL);
      ALLOC_VALACK_OUT(out_EVENT_RESET_ACK,ACK);
    }

    // ~~~~~[ Internal ] ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    internal_DECOD_VAL = new Tcontrol_t [_param->_nb_instruction];

    _queue = new ifetch_queue_entry_t * [_param->_size_queue];
    for (uint32_t i=0;i<_param->_size_queue; i++)
      _queue [i] = new ifetch_queue_entry_t (_param->_nb_instruction);

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
