#include "Common/include/Debug.h"

static uint32_t _debug_depth = 0;


std::string debug_tab (void)
{
  return std::string(_debug_depth,'\t');
}

void debug_function_begin (std::string component, std::string function)
{
  _debug_depth ++;

  log_printf(FUNC,true,function.c_str(),"%sBegin",debug_tab().c_str());
}

void debug_function_end (std::string component, std::string function)
{
  log_printf(FUNC,true,function.c_str(),"%sEnd",debug_tab().c_str());

  _debug_depth --;
}
