#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_direction_glue_Direction_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_direction_glue_Direction_Glue_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace direction_glue {


  class Direction_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL                  ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK                  ;
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS_SRC          ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_STATIC               ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_LAST_TAKE            ;
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY              ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_DIRECTION            ;

  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_PREDICTOR_VAL        ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_ACK        ;
  public    : SC_OUT(Taddress_t)           ** out_PREDICT_PREDICTOR_ADDRESS_SRC;
  public    : SC_IN (Thistory_t)           **  in_PREDICT_PREDICTOR_HISTORY    ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_PREDICTOR_DIRECTION  ;

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_VAL                ;
  public    : SC_OUT(Tcontrol_t)           ** out_UPDATE_ACK                ;
  public    : SC_IN (Taddress_t)           **  in_UPDATE_ADDRESS            ;
  public    : SC_IN (Thistory_t)           **  in_UPDATE_HISTORY            ;
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_DIRECTION          ;

  public    : SC_OUT(Tcontrol_t)           ** out_UPDATE_PREDICTOR_VAL      ;
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_PREDICTOR_ACK      ;
  public    : SC_OUT(Taddress_t)           ** out_UPDATE_PREDICTOR_ADDRESS  ;
  public    : SC_OUT(Thistory_t)           ** out_UPDATE_PREDICTOR_HISTORY  ;
  public    : SC_OUT(Tcontrol_t)           ** out_UPDATE_PREDICTOR_DIRECTION;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Direction_Glue);
#endif
  public  :          Direction_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Direction_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif
  public  : void        genMealy_predict          (void);
  public  : void        genMealy_update           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace direction_glue
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
