/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Load_Store_pointer_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace load_store_pointer_unit {



#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::allocation"
  void Load_Store_pointer_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Load_Store_pointer_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("insert", IN, EAST, "insert to the re order buffer an instruction", _param->_nb_inst_insert); 

      ALLOC1_VALACK_IN ( in_INSERT_VAL                  ,VAL);
      ALLOC1_VALACK_OUT(out_INSERT_ACK                  ,ACK);
      ALLOC1_SIGNAL_IN ( in_INSERT_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t  ,_param->_size_front_end_id   );
      ALLOC1_SIGNAL_IN ( in_INSERT_CONTEXT_ID           ,"context_id"           ,Tcontext_t  ,_param->_size_context_id     );
      ALLOC1_SIGNAL_IN ( in_INSERT_TYPE                 ,"type"                 ,Ttype_t     ,_param->_size_type           );
      ALLOC1_SIGNAL_IN ( in_INSERT_OPERATION            ,"operation"            ,Toperation_t,_param->_size_operation      );
      ALLOC1_SIGNAL_OUT(out_INSERT_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t  ,_param->_size_store_queue_ptr);
      ALLOC1_SIGNAL_OUT(out_INSERT_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t  ,_param->_size_load_queue_ptr );
    }
    
    // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("retire", IN, EAST, "retire from the re order buffer an instruction", _param->_nb_inst_retire); 

      ALLOC1_VALACK_IN ( in_RETIRE_VAL                  ,VAL);
      ALLOC1_VALACK_OUT(out_RETIRE_ACK                  ,ACK);
      ALLOC1_SIGNAL_IN ( in_RETIRE_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t  ,_param->_size_front_end_id   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_CONTEXT_ID           ,"context_id"           ,Tcontext_t  ,_param->_size_context_id     );
      ALLOC1_SIGNAL_IN ( in_RETIRE_TYPE                 ,"type"                 ,Ttype_t     ,_param->_size_type           );
      ALLOC1_SIGNAL_IN ( in_RETIRE_OPERATION            ,"operation"            ,Toperation_t,_param->_size_operation      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t  ,_param->_size_store_queue_ptr);
      ALLOC1_SIGNAL_IN ( in_RETIRE_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t  ,_param->_size_load_queue_ptr );
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    reg_STORE_QUEUE_PTR_WRITE     = new Tlsq_ptr_t      [_param->_nb_load_store_queue];
    reg_STORE_QUEUE_USE           = new bool *          [_param->_nb_load_store_queue];
    reg_STORE_QUEUE_NB_USE        = new Tlsq_ptr_t      [_param->_nb_load_store_queue];
    reg_LOAD_QUEUE_PTR_WRITE      = new Tlsq_ptr_t      [_param->_nb_load_store_queue];
    reg_LOAD_QUEUE_USE            = new bool *          [_param->_nb_load_store_queue];
    
    for (uint32_t i=0; i<_param->_nb_load_store_queue; i++)
      {
	reg_STORE_QUEUE_USE [i] = new bool [_param->_size_store_queue [i]];
	reg_LOAD_QUEUE_USE  [i] = new bool [_param->_size_load_queue  [i]];
      }

    internal_INSERT_ACK           = new Tcontrol_t      [_param->_nb_inst_insert];
    internal_INSERT_OPERATION_USE = new operation_use_t [_param->_nb_inst_insert];
    internal_INSERT_LSQ           = new uint32_t        [_param->_nb_inst_insert];
    internal_INSERT_PTR           = new Tlsq_ptr_t      [_param->_nb_inst_insert];

    internal_RETIRE_ACK           = new Tcontrol_t      [_param->_nb_inst_retire];
    internal_RETIRE_OPERATION_USE = new operation_use_t [_param->_nb_inst_retire];
    internal_RETIRE_LSQ           = new uint32_t        [_param->_nb_inst_retire];
    internal_RETIRE_PTR           = new Tlsq_ptr_t      [_param->_nb_inst_retire];

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };

}; // end namespace load_store_pointer_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
