#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_stat_list_unit_Types_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_stat_list_unit_Types_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {

  class stat_list_entry_t
  {
  private : bool     _is_free ; // set = is present in free list
  private : bool     _is_link ; // set = is present in rat
  private : bool     _is_valid; // set = an instruction have write in this register
  private : uint32_t _counter ; // number of register that must read this register

  public :  stat_list_entry_t (void) {};
  public : ~stat_list_entry_t (void) {};

  public : void reset (bool is_link)
    {
      _is_free  = 0;
      _is_link  = is_link;
      _is_valid = 1;
      _counter  = 0;
    }

  public : void insert_read (void)
    {
      _counter ++;
    }
  public : void insert_write (void)
    {
      _is_free  = 0;
      _is_link  = 1;
      _is_valid = 0;
    }

  public : void retire_read (void)
    {
      _counter --;
    }

  public : void retire_write_old (void)
    {
      _is_link  = 0;
    }

  public : void retire_write_new (void)
    {
      _is_valid = 1;
    }

  public : void free (void)
    {
      _is_free  = 1;
    }

  public : bool can_insert_read (uint32_t max_reader)
    {
      return ((_counter+1) < max_reader);
    }

  public : bool can_free (void)
    {
      return ((_is_free  == 0) and
	      (_is_link  == 0) and
	      (_is_valid == 1) and
	      (_counter  == 0));
    }

  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    stat_list_entry_t & x)
    {
      output_stream << x._is_free  << " "
		    << x._is_link  << " "
		    << x._is_valid << " "
		    << x._counter;
      
      return output_stream;
    }

  };


}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
