#ifndef morpheo_tostring
#define morpheo_tostring

/*
 * $Id$
 *
 * with a stephane dubuisson initial idea
 *
 * [ Description ]
 * 
 */

#include <iosfwd>
#include <sstream>
#include <iomanip>
#include <string>
#include <limits>

namespace morpheo              {
  
  template<typename T> inline std::string toString             (const T& x)
  {
    std::ostringstream out("");
    out << x;
    return out.str();
  }
  
  template<>           inline std::string toString<bool>       (const bool& x)
  {
    std::ostringstream out("");
    //out << boolalpha << x;
    out << x;
    return out.str();
  }
  
  template<>           inline std::string toString<float>      (const float& x)
  {
    const int sigdigits = std::numeric_limits<float>::digits10;
    std::ostringstream out("");
    out << std::setprecision(sigdigits) << x;
    return out.str();
  }
  
  template<>           inline std::string toString<double>     (const double& x)
  {
    const int sigdigits = std::numeric_limits<double>::digits10;
    std::ostringstream out("");
    out << std::setprecision(sigdigits) << x;
    return out.str();
  }
  
  template<>           inline std::string toString<long double>(const long double& x)
  {
    const int sigdigits = std::numeric_limits<long double>::digits10;
    std::ostringstream out("");
    out << std::setprecision(sigdigits) << x;
    return out.str();
  }

  template<>           inline std::string toString< int8_t>       (const int8_t& x)
  {
    std::ostringstream out("");
    out << static_cast< int32_t>(x);
    return out.str();
  }

  template<>           inline std::string toString<uint8_t>       (const uint8_t& x)
  {
    std::ostringstream out("");
    out << static_cast<uint32_t>(x);
    return out.str();
  }

  template<>           inline std::string toString< int16_t>      (const int16_t& x)
  {
    std::ostringstream out("");
    out << static_cast< int32_t>(x);
    return out.str();
  }

  template<>           inline std::string toString<uint16_t>      (const uint16_t& x)
  {
    std::ostringstream out("");
    out << static_cast<uint32_t>(x);
    return out.str();
  }

  template<>           inline std::string toString< int32_t>      (const int32_t& x)
  {
    std::ostringstream out("");
    out << x;
    return out.str();
  }

  template<>           inline std::string toString<uint32_t>      (const uint32_t& x)
  {
    std::ostringstream out("");
    out << x;
    return out.str();
  }
  
}; // end namespace morpheo              

#endif
