#include "../include/Cache_OneLevel.h"

namespace environment {
namespace cache {
namespace cache_onelevel {
  
  // Return hit (true) 
  // uncache is to stocke the address on the cache
  type_rsp_cache_t Cache_OneLevel::access (uint32_t num_port, 
					   uint32_t address, 
					   uint32_t trdid, 
					   type_req_cache_t type, 
					   direction_req_cache_t dir)
  {
//     std::cout << "<Cache_Onelevel.access>" << std::endl
// 	      << " * num_port   : " << num_port << std::endl
// 	      << " * address    : " << std::hex << address  << std::dec << std::endl
// 	      << " * trdid      : " << trdid    << std::endl
// 	      << " * type       : " << type     << std::endl
// 	      << " * direction  : " << dir      << std::endl;

    switch (type)
      {
      case UNCACHED   : return access_uncached   (num_port,address,trdid    ); break;
      case INVALIDATE : return access_invalidate (num_port,address,trdid    ); break;
      case FLUSH      : return access_flush      (num_port,address,trdid    ); break;
      case PREFETCH   : // no difference with the simple read cached (have no add a prefetch cache)
      case CACHED     : return access_cached     (num_port,address,trdid,dir); break;
      default         : std::cout << "<Cache_Onelevel.access> unknow type : " << std::endl; exit(1); break;
      }
  }

};
};
};
