#include "../include/Cache.h"
#include <sstream>

namespace environment {
namespace cache {

  Cache::Cache (std::string name,
		Parameters * param)
  {
    this->name  = name;
    this->param = param;

    cache_shared = new cache_multilevel::Cache_MultiLevel (name+"_cache_shared",param->param_cache_shared);

    icache_dedicated = new cache_multilevel::Cache_MultiLevel * [param->nb_cache_dedicated];
    dcache_dedicated = new cache_multilevel::Cache_MultiLevel * [param->nb_cache_dedicated];

      for (uint32_t i=0; i<param->nb_cache_dedicated; i++)
	{
	  {
	    std::stringstream str;
	    str << name << "_icache_dedicated_" << i;

	    icache_dedicated [i] = new cache_multilevel::Cache_MultiLevel(str.str(),param->param_icache_dedicated [i]);
	  }
	  {
	    std::stringstream str;
	    str << name << "_dcache_dedicated_" << i;

	    dcache_dedicated [i] = new cache_multilevel::Cache_MultiLevel(str.str(),param->param_dcache_dedicated [i]);
	  }
	}
  }

  Cache::~Cache (void)
  {
    for (uint32_t i=0; i<param->nb_cache_dedicated; i++)
      {
	delete    icache_dedicated [i];
	delete    dcache_dedicated [i];
      }
    delete [] icache_dedicated;
    delete [] dcache_dedicated;
    delete    cache_shared    ;
  }
};
};
