#ifndef ENVIRONMENT_QUEUE_QUEUE_H
#define ENVIRONMENT_QUEUE_QUEUE_H

#include <stdint.h>
#include <iostream>
#include "Slot.h"

namespace environment {
namespace queue {
  
  template <class T>
  class Queue
  {
  protected : std::string _name;
  protected : uint32_t    _nb_slot;   // number of slot
  protected : uint32_t    _size;      // size of queue
  protected : slot_t<T> * _slot;

  public : Queue (std::string name,
		  uint32_t size)
      {
	_name    = name;
	_nb_slot = 0;
	_size    = size;
	_slot    = new slot_t<T> [size];
      };

    public : virtual ~Queue ()
      {
	delete [] _slot;
      };

      // *****[ empty ]*****
      // Test if the queue is empty
    public : bool empty ()
      {
	return (_nb_slot == 0);
      }
      
      // *****[ full ]*****
      // Test if the queue is full
    public : bool full ()
      {
	return (_nb_slot == _size);
      }

      // *****[ nb_slot_free ]*****
      // return the number of free slot
    public : uint32_t nb_slot_free ()
      {
	return (_size-_nb_slot);
      }

      // *****[ nb_slot_use ]*****
      // return the number of use slot
    public : uint32_t nb_slot_use ()
      {
	return (_nb_slot);
      }

      // *****[ pop ]*****
      // read the queue, and update the pointer
    public : virtual T    pop  ()             {return T();};

      // *****[ pop ]*****
      // read the queue, and update the pointer
    public : virtual T    pop  (uint32_t num) {return T();};

      // *****[ push ]*****
      // Push a new value (they must have a slot free)
    public : virtual bool push (T val)        {return false;};
  
    }; // Queue
  
};
};
#endif
  
