#ifndef ENVIRONMENT_CACHE_H
#define ENVIRONMENT_CACHE_H

#include "Cache_Parameters.h"
#include "Cache_MultiLevel.h"
#include "Types.h"

namespace environment {
namespace cache {

  class Cache
  {
  private   : std::string         name            ;
  protected : Parameters        * param           ;

  protected : cache_multilevel::Cache_MultiLevel ** icache_dedicated;
  protected : cache_multilevel::Cache_MultiLevel ** dcache_dedicated;
  protected : cache_multilevel::Cache_MultiLevel  * cache_shared    ;

  public    :  Cache (std::string  name,
	    	     Parameters * param);
  public    : ~Cache (void);

  public    : void        reset       (void);
  public    : void        transition  (void);
  private   : uint32_t    range_port  (cache_t  type_cache, 
				       uint32_t num_entity);
  public    : uint32_t    latence     (cache_t               type_cache, 
				       uint32_t              num_entity, 
				       uint32_t              num_port  , 
				       uint32_t              address   , 
				       uint32_t              trdid     , 
				       type_req_cache_t      type      ,
				       direction_req_cache_t dir    );

  public    : std::string information (uint32_t depth);

  public    : friend std::ostream& operator<< (std::ostream& output, Cache & x);
  };

};
};
#endif
