#include <iostream>
#include "../include/Sort_Queue.h"
#include "../include/Sort_Queue_Dynamic.h"

using namespace std;
using namespace environment;
using namespace environment::queue;


#define TEST(x,y)				\
  {						\
    cout << "Line " << __LINE__ << " : ";	\
    if (x==y)					\
      {						\
	cout << "Test OK" << endl;		\
      }						\
    else					\
      {						\
	cout << "Test KO" << endl;		\
	exit (EXIT_FAILURE);			\
      }						\
  } while (0)

class Entry
{
public : uint32_t _trdid;  // number of thread
public : uint32_t _pktid;  // number of packet
public : uint64_t _data;

  Entry (void)
  {
    _trdid = 0;
    _pktid = 0;
    _data  = 0;
  };
  
  Entry (uint32_t trdid ,
	 uint32_t pktid ,
	 uint64_t data  )
  {
    _trdid = trdid;
    _pktid = pktid;
    _data  = data ;
  };
  
  friend std::ostream& operator<< (std::ostream& output, Entry x)
  {
    output << x._trdid << " " << x._pktid << " " << std::hex << x._data << std::dec;
    return output;
  }
};


int main (void)
{
  cout << "<main> Begin" << endl;

  {
    cout << "<main> * create and print a slot_t" << endl;
    slot_t<uint32_t> * my_slot = new slot_t<uint32_t> (12, 0xdeadbeef);
    cout << *my_slot << endl;
    
    delete my_slot;
  }
  
  {
    cout << "==================================" << endl; 
    cout << "=====[ Sort_Queue ]===============" << endl;
    cout << "==================================" << endl;     
    cout << "<main>  * create a queue, size = 5" << endl;
    Parameters * param = new Parameters (5);
    
    Sort_Queue <Entry> * my_Sort_Queue = new Sort_Queue <Entry> ("my_queue",param);
    
    cout << " * must be empty ..." << endl;
    TEST(my_Sort_Queue->empty(),true );
    TEST(my_Sort_Queue->full (),false);
    
    cout << " * insert 6 elements" << endl;
    
    TEST(my_Sort_Queue->push((uint32_t)5,Entry(1,1,0x33333333)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)6,Entry(2,2,0x55555555)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)3,Entry(3,3,0x22222222)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)5,Entry(4,4,0x44444444)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)1,Entry(5,5,0x11111111)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)4,Entry(6,6,0x00000BAD)),false); cout << *my_Sort_Queue << endl;
    
    cout << " * extract 6 elements" << endl;
    TEST(my_Sort_Queue->pop()._data,0x11111111); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->empty(),false);
    TEST(my_Sort_Queue->pop()._data,0x22222222); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->empty(),false);
    TEST(my_Sort_Queue->pop()._data,0x33333333); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->empty(),false);
    TEST(my_Sort_Queue->pop()._data,0x44444444); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->empty(),false);
    TEST(my_Sort_Queue->pop()._data,0x55555555); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->empty(),true );
    
    cout << " * ajout de 8 elements (reset apres le deuxieme)" << endl;
    
    TEST(my_Sort_Queue->push((uint32_t)5,Entry(1,1,0x44444444)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)6,Entry(2,2,0x55555555)),true ); cout << *my_Sort_Queue << endl;
    my_Sort_Queue->reset();					           
    TEST(my_Sort_Queue->push((uint32_t)3,Entry(3,3,0x22222222)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)5,Entry(4,4,0x33333333)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)5,Entry(1,1,0x44444444)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)7,Entry(2,2,0x55555555)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)1,Entry(5,5,0x11111111)),true ); cout << *my_Sort_Queue << endl;
    TEST(my_Sort_Queue->push((uint32_t)4,Entry(6,6,0x00000BAD)),false); cout << *my_Sort_Queue << endl;
    
    cout << " * 3 transitions" << endl;
    
    my_Sort_Queue->transition(); cout << *my_Sort_Queue << endl;
    my_Sort_Queue->transition(); cout << *my_Sort_Queue << endl;
    my_Sort_Queue->transition(); cout << *my_Sort_Queue << endl;
    
    cout << " * extract 1 element" << endl;
    
    TEST(my_Sort_Queue->pop()._data,0x11111111);
    
    cout << *my_Sort_Queue << endl;
    
    for (uint32_t it = 0; it < my_Sort_Queue->nb_slot_use(); it ++)
      {
	slot_t<Entry> val = my_Sort_Queue->read(it);
	cout << val._delay << " " << val._data << endl;
      }
    
    cout << " * Test pop(n)" << endl;
    
    TEST(my_Sort_Queue->pop(1)._data, 0x33333333);
    TEST(my_Sort_Queue->pop(2)._data, 0x55555555);
    TEST(my_Sort_Queue->pop(0)._data, 0x22222222);
    TEST(my_Sort_Queue->pop(0)._data, 0x44444444);
    
    delete my_Sort_Queue;
    delete param;
  }

  {
    cout << "==================================" << endl; 
    cout << "=====[ Sort_Queue_Dynamic ]=======" << endl;
    cout << "==================================" << endl;     
    cout << "<main>  * create a queue, size = 5" << endl;
    Parameters * param = new Parameters (5);
    
    Sort_Queue_Dynamic <Entry> * my_Sort_Queue_Dynamic = new Sort_Queue_Dynamic <Entry> ("my_queue",param);

    cout << " * must be empty ..." << endl;
    
    TEST(my_Sort_Queue_Dynamic->empty(),true);
    TEST(my_Sort_Queue_Dynamic->full (),false);

    TEST(my_Sort_Queue_Dynamic->push(5,Entry(1,1, 4)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(6,Entry(2,2, 6)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(3,Entry(3,3, 2)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(5,Entry(4,4, 5)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(1,Entry(5,5, 1)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(4,Entry(6,6, 3)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(9,Entry(1,1,12)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(6,Entry(2,2, 7)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(7,Entry(3,3, 8)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(7,Entry(4,4, 9)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(8,Entry(5,5,11)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(7,Entry(6,6,10)),true ); cout << *my_Sort_Queue_Dynamic << endl;

    TEST(my_Sort_Queue_Dynamic->pop()._data, 1 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 2 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 3 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 4 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 5 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 6 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 7 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 8 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 9 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data,10 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data,11 ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data,12 ); cout << *my_Sort_Queue_Dynamic << endl;


    TEST(my_Sort_Queue_Dynamic->push(5,Entry(1,1, 4)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(6,Entry(2,2, 6)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(3,Entry(3,3, 2)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(5,Entry(4,4, 5)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(1,Entry(5,5, 1)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(4,Entry(6,6, 3)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(9,Entry(1,1,12)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(6,Entry(2,2, 7)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(7,Entry(3,3, 8)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(7,Entry(4,4, 9)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(8,Entry(5,5,11)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(7,Entry(6,6,10)),true ); cout << *my_Sort_Queue_Dynamic << endl;

    TEST(my_Sort_Queue_Dynamic->pop()._data, 1 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 2 )            ; cout << *my_Sort_Queue_Dynamic << endl;

    TEST(my_Sort_Queue_Dynamic->push(0,Entry(1,1, 1)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(0,Entry(2,2, 2)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 1 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 2 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(0,Entry(1,1, 1)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(0,Entry(2,2, 2)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 1 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 2 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(0,Entry(1,1, 1)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(0,Entry(2,2, 2)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 1 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 2 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(0,Entry(1,1, 1)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->push(0,Entry(2,2, 2)),true ); cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 1 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 2 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop()._data, 3 )            ; cout << *my_Sort_Queue_Dynamic << endl;
    TEST(my_Sort_Queue_Dynamic->pop(2)._data, 6 )           ; cout << *my_Sort_Queue_Dynamic << endl;

    delete my_Sort_Queue_Dynamic;
    delete param;
  }

  cout << "<main> End" << endl;

  return EXIT_SUCCESS;
}
