#include "../include/Sim2OS.h"

namespace environment {
namespace sim2os {

  void * Sim2OS::service_open (void)
  {
    if (have_all_arguments(3) == false)
      {
	std::cerr << "<" << name << "> Usage : int open(const char *pathname, int flags, mode_t mode);" << std::endl;
	return NULL;
      }
    
    const char *pathname = (const char *) convert_address(arguments[1]);
    int         flags    = (int)          arguments[2];
    mode_t      mode     = (mode_t)       arguments[3];
    void *      result   = (void *)       open(pathname,flags,mode);
    error                = errno;
    
    std::cout << "\n\t***** service : open          *****"               << std::endl;
    std::cout << "\tpathname  : " <<                            pathname << std::endl;
    std::cout << "\tflags /8  : " << std::oct << (unsigned int) flags    << std::endl;
    std::cout << "\tflags /10 : " << std::dec << (unsigned int) flags    << std::endl;
    std::cout << "\tflags /16 : " << std::hex << (unsigned int) flags    << std::endl;
    std::cout << "\tmode  /8  : " << std::oct << (unsigned int) mode     << std::endl;
    std::cout << "\tmode  /10 : " << std::dec << (unsigned int) mode     << std::endl;
    std::cout << "\tmode  /16 : " << std::hex << (unsigned int) mode     << std::endl;
    std::cout << "\tresult    : " << std::dec << (unsigned int) result   << std::endl;
    std::cout << "\terrno     : " <<             (unsigned int) error    << std::endl;
    
    return      result;
  }

};
};
