#include "../include/Sim2OS.h"

namespace environment {
namespace sim2os {

  void * Sim2OS::service_time (void)
  {
    if (have_all_arguments(1) == false)
      {
	std::cerr << "<" << name << "> Usage : time_t time(time_t * t);" << std::endl;
	return NULL;
      }
    
    time_t *t      = (time_t *)     convert_address(arguments[1]);
    void *  result = (void *)       time(t);
    error          = errno;
    
    std::cout << "\n\t***** service : time          *****" << std::endl;
    std::cout << "\tt         : " << std::hex << (unsigned int) t                                      << std::endl;
    std::cout << "\tresult    : " << std::dec << (unsigned int) result << " - " << ctime((time_t *) t) << std::endl;
    std::cout << "\terrno     : " <<             (unsigned int) error                                  << std::endl;
    
    // Must swap, because it's a pointer
    t = (time_t *)endianness::swapBytes((char *)t,sizeof(time_t),sizeof(time_t));
    
    return result;
  }

};
};
