/*
 * $Id: Parameters_msg_error.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::msg_error"
  std::string Parameters::msg_error(void)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    std::string msg = "";

    if (_nb_inst_decod == 0)
      msg += "  - nb_inst_decod must be > 0.\n";

    if ((_size_general_data != 32) and
	(_size_general_data != 64))
      msg += "  - size_general_data must be equal at 32 or 64 bits.\n";

    if ((_nb_branch_speculated == 0) or
	(_nb_branch_speculated > _nb_context))
      msg += "  - nb_branch_speculated must be in [1:nb_context].\n";

    if ((_nb_context_select == 0) or
        (_nb_context_select > _nb_context))
      msg += "  - nb_context_select must be in [1:nb_context].\n";

    if ((_priority != PRIORITY_ROUND_ROBIN))
      msg += "  - Unsupported priority scheme. Supported scheme are : "+toString(PRIORITY_ROUND_ROBIN)+".\n";
    
    if ((_load_balancing != LOAD_BALANCING_MAXIMUM_FOR_PRIORITY))
      msg += "  - Unsupported load_balancing scheme. Supported scheme are : "+toString(LOAD_BALANCING_MAXIMUM_FOR_PRIORITY)+".\n";

    return msg;

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
