/*
 * $Id: Ifetch_queue.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::Ifetch_queue"
  Ifetch_queue::Ifetch_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    log_printf(INFO,Ifetch_queue,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {	
	log_printf(INFO,Ifetch_queue,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (_usage & USE_VHDL)
      {
	// generate the vhdl
	log_printf(INFO,Ifetch_queue,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (_usage & USE_SYSTEMC)
      {
	// constant output
	internal_ICACHE_RSP_ACK  = 1;
	internal_EVENT_RESET_ACK = 1;

	PORT_WRITE(out_ICACHE_RSP_ACK , internal_ICACHE_RSP_ACK );
	PORT_WRITE(out_EVENT_RESET_ACK, internal_EVENT_RESET_ACK);

	log_printf(INFO,Ifetch_queue,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Ifetch_queue,FUNCTION,"Method - genMoore");

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Ifetch_queue::~Ifetch_queue"
  Ifetch_queue::~Ifetch_queue (void)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (_usage & USE_STATISTICS)
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Ifetch_queue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
