/*
 * $Id: Parameters_msg_error.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {


#undef  FUNCTION
#define FUNCTION "Stat_List_unit::msg_error"
  std::string Parameters::msg_error(void)
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

    std::string msg = "";

    if (not is_multiple(_nb_bank, _nb_reg_free))
      msg += "  - nb_bank must be a multiple of nb_reg_free.\n";

    if (_nb_general_register < _nb_gpr_use_init)
      msg += "  - the number of physical general register is insuffisant. (you need less "+toString(_nb_gpr_use_init)+" registers.\n";

    if (_nb_special_register < _nb_spr_use_init)
      msg += "  - the number of physical special register is insuffisant. (you need less "+toString(_nb_spr_use_init)+" registers.\n";
    
    if (not is_power2(_nb_general_register))
      msg += "  - the number of physical general register must be a power of 2.\n";

    if (not is_power2(_nb_special_register))
      msg += "  - the number of physical special register must be a power of 2.\n";

    if (not is_power2(_nb_bank))
      msg += "  - the number of bank must be a power of 2.\n";

    return msg;

    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
