/*
 * $Id: test.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#include "Behavioural/Generic/Queue/SelfTest/include/test.h"
#include "Common/include/Test.h"

#define NB_ITERATION  1
#define CYCLE_MAX     (2048*NB_ITERATION)

#define LABEL(str)                                                                       \
{                                                                                        \
  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} " << str << endl; \
} while(0)

static uint32_t cycle = 0;

#define SC_START(cycle_offset)                                          \
do                                                                      \
{                                                                       \
/*cout << "SC_START (begin)" << endl;*/                                 \
                                                                        \
  uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time()); \
  if (cycle_current != cycle)                                           \
    {                                                                   \
      cycle = cycle_current;                                            \
      cout << "##########[ cycle "<< cycle << " ]" << endl;             \
    }                                                                   \
                                                                        \
  if (cycle_current > CYCLE_MAX)                                        \
    {                                                                   \
      TEST_KO("Maximal cycles Reached");                                \
    }                                                                   \
  sc_start(cycle_offset);                                               \
/*cout << "SC_START (end  )" << endl;*/                                 \
} while(0)

void test (string name,
	   morpheo::behavioural::generic::queue::Parameters * _param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Queue * _Queue = new Queue (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");
  sc_signal<Tcontrol_t> *  in_INSERT_VAL  = new sc_signal<Tcontrol_t> ( "in_INSERT_VAL" );
  sc_signal<Tcontrol_t> * out_INSERT_ACK  = new sc_signal<Tcontrol_t> ("out_INSERT_ACK" );
  sc_signal<Tdata_t   > *  in_INSERT_DATA = new sc_signal<Tdata_t   > ( "in_INSERT_DATA");
  sc_signal<Tcontrol_t> * out_RETIRE_VAL  = new sc_signal<Tcontrol_t> ("out_RETIRE_VAL" );
  sc_signal<Tcontrol_t> *  in_RETIRE_ACK  = new sc_signal<Tcontrol_t> ( "in_RETIRE_ACK" );
  sc_signal<Tdata_t   > * out_RETIRE_DATA = new sc_signal<Tdata_t   > ("out_RETIRE_DATA");
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _Queue" << endl;
  
  (*(_Queue->in_CLOCK))        (*(in_CLOCK));
  (*(_Queue->in_NRESET))       (*(in_NRESET));

  (*(_Queue-> in_INSERT_VAL )) (*( in_INSERT_VAL ));
  (*(_Queue->out_INSERT_ACK )) (*(out_INSERT_ACK ));
  (*(_Queue-> in_INSERT_DATA)) (*( in_INSERT_DATA));
  (*(_Queue->out_RETIRE_VAL )) (*(out_RETIRE_VAL ));
  (*(_Queue-> in_RETIRE_ACK )) (*( in_RETIRE_ACK ));
  (*(_Queue->out_RETIRE_DATA)) (*(out_RETIRE_DATA));

  cout << "<" << name << "> Start Simulation ............" << endl;
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation
  const  int32_t percent_insert_transaction = 75;
  const  int32_t percent_retire_transaction = 75;
  const uint32_t nb_request = 3*_param->_size_queue;

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  in_INSERT_VAL -> write(0);
  in_RETIRE_ACK -> write(0);

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  uint32_t data_in  = 0;
  uint32_t data_out = 0;

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration "+toString(iteration));

      while (data_out <= nb_request)
	{
	  in_INSERT_VAL  -> write((rand()%100)<percent_insert_transaction);
	  in_INSERT_DATA -> write(data_in);
	  in_RETIRE_ACK  -> write((rand()%100)<percent_retire_transaction);

	  SC_START(0); // genMoore

	  if ( in_INSERT_VAL->read() and out_INSERT_ACK->read())
	    {
	      LABEL ("Transaction with interface : INSERT");
	      data_in ++;
	    }
	  if (out_RETIRE_VAL->read() and  in_RETIRE_ACK->read())
	    {
	      LABEL ("Transaction with interface : RETIRE");
	      TEST(Tdata_t, out_RETIRE_DATA->read(), data_out);
	      data_out++;
	    }

	  SC_START(1);
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;
  cout << "<" << name << "> ............ Stop Simulation" << endl;

  delete in_CLOCK;
  delete in_NRESET;
#endif

  delete _Queue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
