/*
 * $Id: Load_store_unit.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Load_store_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::Load_store_unit"
#ifdef SYSTEMC
  Load_store_unit::Load_store_unit (sc_module_name name,
#else
  Load_store_unit::Load_store_unit (string name,
#endif
#ifdef STATISTICS
			  morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
			  morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters * param ):
			      _name              (name)
			      ,_param            (param)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");

#ifdef SYSTEMC
    log_printf(INFO,Load_store_unit,FUNCTION,"Allocation");

    allocation ();
#endif

#ifdef STATISTICS
    log_printf(INFO,Load_store_unit,FUNCTION,"Allocation of statistics");

    statistics_declaration(param_statistics);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(INFO,Load_store_unit,FUNCTION,"Generate the vhdl");

    vhdl();
#endif

#ifdef SYSTEMC
    // Function pointer

    switch (_param->_speculative_load)
      {
      case SPECULATIVE_LOAD_COMMIT :
	{
	  function_transition      = &morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::function_speculative_load_commit_transition     ;
	  function_genMoore        = &morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::function_speculative_load_commit_genMoore       ;
	  function_genMealy_dcache = &morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::function_speculative_load_commit_genMealy_dcache;
	  function_genMealy_insert = &morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::function_speculative_load_commit_genMealy_insert;
	  function_genMealy_retire = &morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::function_speculative_load_commit_genMealy_retire;
	  break;
	}
      case NO_SPECULATIVE_LOAD     :
      case SPECULATIVE_LOAD_ACCESS :
	//case SPECULATIVE_LOAD_BYPASS :
      default                      :
	{
	  break;
	}
      }

    log_printf(INFO,Load_store_unit,FUNCTION,"Constant affectation");

    internal_DCACHE_RSP_ACK = 1;
    PORT_WRITE(out_DCACHE_RSP_ACK, 1);

    log_printf(INFO,Load_store_unit,FUNCTION,"Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

    log_printf(INFO,Load_store_unit,FUNCTION,"Method - genMoore");

    SC_METHOD (genMoore);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

    log_printf(INFO,Load_store_unit,FUNCTION,"Method - genMealy_insert");

    SC_METHOD (genMealy_insert);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);
    sensitive     << *(in_MEMORY_IN_OPERATION);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    (*(out_MEMORY_IN_ACK)) (*(in_MEMORY_IN_OPERATION));
#endif    

    log_printf(INFO,Load_store_unit,FUNCTION,"Method - genMealy_retire");

    SC_METHOD (genMealy_retire);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

    log_printf(INFO,Load_store_unit,FUNCTION,"Method - genMealy_dcache");

    SC_METHOD (genMealy_dcache);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

#endif
    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Load_store_unit::~Load_store_unit"
  Load_store_unit::~Load_store_unit (void)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    log_printf(INFO,Load_store_unit,FUNCTION,"Generate Statistics file");

    delete _stat;
#endif

#ifdef SYSTEMC
    log_printf(INFO,Load_store_unit,FUNCTION,"Deallocation");

    deallocation ();
#endif

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
