#ifndef morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_unit_glue_Ifetch_unit_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_unit_glue_Ifetch_unit_Glue_h

/*
 * $Id: Ifetch_unit_Glue.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_unit_glue {


  class Ifetch_unit_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           ) * out_ICACHE_REQ_VAL         ;
  public    : SC_IN (Tcontrol_t           ) *  in_ICACHE_REQ_ADDRESS_VAL ;
  public    : SC_OUT(Tcontrol_t           ) * out_ICACHE_REQ_QUEUE_VAL   ;

  public    : SC_IN (Tcontrol_t           ) *  in_ICACHE_REQ_ACK         ;
  public    : SC_OUT(Tcontrol_t           ) * out_ICACHE_REQ_ADDRESS_ACK ;
  public    : SC_IN (Tcontrol_t           ) *  in_ICACHE_REQ_QUEUE_ACK   ;
    
  public    : SC_OUT(Ticache_type_t       ) * out_ICACHE_REQ_TYPE        ;

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           ) *  in_EVENT_VAL              ;
  public    : SC_OUT(Tcontrol_t           ) * out_EVENT_ADDRESS_VAL      ;
  public    : SC_OUT(Tcontrol_t           ) * out_EVENT_QUEUE_VAL        ;

  public    : SC_OUT(Tcontrol_t           ) * out_EVENT_ACK              ;
  public    : SC_IN (Tcontrol_t           ) *  in_EVENT_ADDRESS_ACK      ;
  public    : SC_IN (Tcontrol_t           ) *  in_EVENT_QUEUE_ACK        ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Ifetch_unit_Glue);
#endif
  public  :          Ifetch_unit_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Ifetch_unit_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif
  public  : void        genMealy_icache_req       (void);
  public  : void        genMealy_event            (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace ifetch_unit_glue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
