/*
 * $Id: Branch_Target_Buffer_Register_allocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Branch_Target_Buffer_Register.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_register {



#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Register::allocation"
  void Branch_Target_Buffer_Register::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Branch_Target_Buffer_Register"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("predict", IN, SOUTH, "Compute next pc.", _param->_nb_inst_predict);

      ALLOC1_VALACK_IN ( in_PREDICT_VAL         ,VAL);
      ALLOC1_VALACK_OUT(out_PREDICT_ACK         ,ACK);
      ALLOC1_SIGNAL_IN ( in_PREDICT_CONTEXT_ID  ,"context_id"  ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_PREDICT_ADDRESS     ,"address"     ,Tgeneral_data_t    ,_param->_size_address);

      {
	ALLOC2_INTERFACE("predict", OUT, SOUTH, "Compute next pc.", _param->_nb_inst_predict, _param->_associativity);
 
	ALLOC2_SIGNAL_OUT(out_PREDICT_HIT         ,"hit"         ,Tcontrol_t         ,1);
	ALLOC2_SIGNAL_OUT(out_PREDICT_ADDRESS_SRC ,"address_src" ,Tgeneral_data_t    ,_param->_size_address);
	ALLOC2_SIGNAL_OUT(out_PREDICT_ADDRESS_DEST,"address_dest",Tgeneral_data_t    ,_param->_size_address);
	ALLOC2_SIGNAL_OUT(out_PREDICT_CONDITION   ,"condition"   ,Tbranch_condition_t,_param->_size_branch_state);
	ALLOC2_SIGNAL_OUT(out_PREDICT_LAST_TAKE   ,"last_take"   ,Tcontrol_t         ,1);
	ALLOC2_SIGNAL_OUT(out_PREDICT_IS_ACCURATE ,"is_accurate" ,Tcontrol_t         ,1);
      }
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("decod", IN, SOUTH, "decod instruction", _param->_nb_inst_decod);

      ALLOC1_VALACK_IN ( in_DECOD_VAL            ,VAL);
      ALLOC1_VALACK_OUT(out_DECOD_ACK            ,ACK);
      ALLOC1_SIGNAL_OUT(out_DECOD_HIT            ,"hit"            ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_DECOD_HIT_INDEX      ,"hit_index"      ,Tptr_t             ,_param->_size_victim);
      ALLOC1_SIGNAL_IN ( in_DECOD_VICTIM         ,"victim"         ,Tptr_t             ,_param->_size_victim);
      ALLOC1_SIGNAL_IN ( in_DECOD_CONTEXT_ID     ,"context_id"     ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_DECOD_ADDRESS_SRC    ,"address_src"    ,Tgeneral_data_t    ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_DECOD_ADDRESS_DEST   ,"address_dest"   ,Tgeneral_data_t    ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_DECOD_CONDITION      ,"condition"      ,Tbranch_condition_t,_param->_size_branch_state);
      ALLOC1_SIGNAL_IN ( in_DECOD_LAST_TAKE      ,"last_take"      ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_MISS_PREDICTION,"miss_prediction",Tcontrol_t         ,1);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("update", IN, SOUTH, "update instruction", _param->_nb_inst_update);

      ALLOC1_VALACK_IN ( in_UPDATE_VAL            ,VAL);
      ALLOC1_VALACK_OUT(out_UPDATE_ACK            ,ACK);
      ALLOC1_SIGNAL_OUT(out_UPDATE_HIT            ,"hit"            ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_HIT_INDEX      ,"hit_index"      ,Tptr_t             ,_param->_size_victim);
      ALLOC1_SIGNAL_IN ( in_UPDATE_VICTIM         ,"victim"         ,Tptr_t             ,_param->_size_victim);
      ALLOC1_SIGNAL_IN ( in_UPDATE_CONTEXT_ID     ,"context_id"     ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_UPDATE_ADDRESS_SRC    ,"address_src"    ,Tgeneral_data_t    ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_UPDATE_ADDRESS_DEST   ,"address_dest"   ,Tgeneral_data_t    ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_UPDATE_CONDITION      ,"condition"      ,Tbranch_condition_t,_param->_size_branch_state);
      ALLOC1_SIGNAL_IN ( in_UPDATE_LAST_TAKE      ,"last_take"      ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_MISS_PREDICTION,"miss_prediction",Tcontrol_t         ,1);
    }

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    reg_BTB = new btb_entry_t * [_param->_size_bank];
    for (uint32_t i=0; i<_param->_size_bank; i++)
      reg_BTB [i] = new btb_entry_t [_param->_associativity];

    internal_DECOD_ACK        = new Tcontrol_t [_param->_nb_inst_decod];
    internal_DECOD_HIT        = new Tcontrol_t [_param->_nb_inst_decod];
    internal_DECOD_NUM_BANK   = new uint32_t   [_param->_nb_inst_decod];
    internal_DECOD_NUM_ENTRY  = new uint32_t   [_param->_nb_inst_decod];

    internal_UPDATE_ACK       = new Tcontrol_t [_param->_nb_inst_update];
    internal_UPDATE_HIT       = new Tcontrol_t [_param->_nb_inst_update];
    internal_UPDATE_NUM_BANK  = new uint32_t   [_param->_nb_inst_update];
    internal_UPDATE_NUM_ENTRY = new uint32_t   [_param->_nb_inst_update];

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_register
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
