/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {


#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::Parameters"
  Parameters::Parameters (uint32_t   nb_context     ,
			  uint32_t   size_address   ,
			  uint32_t * nb_instruction ,
			  uint32_t * size_depth     ,
			  uint32_t   nb_inst_predict,
			  uint32_t   nb_inst_decod  ,
			  uint32_t   nb_inst_update )
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");

    _nb_context                = nb_context             ;
    _size_address              = size_address           ;
    _nb_instruction            = nb_instruction         ;
    _size_depth                = size_depth             ;
    _nb_inst_predict           = nb_inst_predict        ;
    _nb_inst_decod             = nb_inst_decod          ;
    _nb_inst_update            = nb_inst_update         ;

    _size_context_id           = log2(_nb_context);
    _size_inst_ifetch_ptr      = new uint32_t [_nb_context];

    _have_port_context_id      = (_size_context_id>0);
    _have_port_depth           = new bool [_nb_context];
    _have_port_inst_ifetch_ptr = new bool [_nb_context];

    for (uint32_t i=0; i<_nb_context; i++)
      {
	_size_inst_ifetch_ptr      [i] = log2(_nb_instruction [i]);
	_have_port_depth           [i] = (_size_depth [i] > 0);
	_have_port_inst_ifetch_ptr [i] = (_size_inst_ifetch_ptr [i] > 0);
      }

    test();
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Prediction_unit_Glue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");
    delete  [] _size_inst_ifetch_ptr     ;
    delete  [] _have_port_depth          ;
    delete  [] _have_port_inst_ifetch_ptr;
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
