/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Prediction_unit_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {


#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::deallocation"
  void Prediction_unit_Glue::deallocation (void)
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	// ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        DELETE1_SIGNAL( in_PREDICT_VAL                        ,_param->_nb_context     ,1);
        DELETE1_SIGNAL(out_PREDICT_ACK                        ,_param->_nb_context     ,1);
        DELETE1_SIGNAL( in_PREDICT_PC_PREVIOUS                ,_param->_nb_context     ,_param->_size_address);
        DELETE1_SIGNAL( in_PREDICT_PC_CURRENT                 ,_param->_nb_context     ,_param->_size_address);
        DELETE1_SIGNAL( in_PREDICT_PC_CURRENT_IS_DS_TAKE      ,_param->_nb_context     ,1);
        DELETE1_SIGNAL(out_PREDICT_PC_NEXT                    ,_param->_nb_context     ,_param->_size_address);
        DELETE1_SIGNAL(out_PREDICT_PC_NEXT_IS_DS_TAKE         ,_param->_nb_context     ,1);
        DELETE1_SIGNAL(out_PREDICT_INST_IFETCH_PTR            ,_param->_nb_context     ,_param->_size_inst_ifetch_ptr [alloc_signal_it1]);
        DELETE1_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_context     ,_param->_size_branch_state);
        DELETE1_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_context     ,_param->_size_depth [alloc_signal_it1]);
        DELETE2_SIGNAL(out_PREDICT_INSTRUCTION_ENABLE         ,_param->_nb_context     ,_param->_nb_instruction[alloc_signal_it1],1);
        DELETE1_SIGNAL(out_PREDICT_BTB_VAL                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_BTB_ACK                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_BTB_CONTEXT_ID             ,_param->_nb_inst_predict,_param->_size_context_id);
        DELETE1_SIGNAL(out_PREDICT_BTB_ADDRESS                ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL( in_PREDICT_BTB_HIT                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_BTB_ADDRESS_SRC            ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL( in_PREDICT_BTB_ADDRESS_DEST           ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL( in_PREDICT_BTB_CONDITION              ,_param->_nb_inst_predict,_param->_size_branch_condition);
//      DELETE1_SIGNAL( in_PREDICT_BTB_LAST_TAKE              ,_param->_nb_inst_predict,1);
	DELETE1_SIGNAL( in_PREDICT_BTB_IS_ACCURATE            ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_DIR_VAL                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_DIR_ACK                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_DIR_ADDRESS_SRC            ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL(out_PREDICT_DIR_STATIC                 ,_param->_nb_inst_predict,1);
//      DELETE1_SIGNAL(out_PREDICT_DIR_LAST_TAKE              ,_param->_nb_inst_predict,1);
//      DELETE1_SIGNAL( in_PREDICT_DIR_HISTORY                ,_param->_nb_inst_predict,_param->_size_history);
        DELETE1_SIGNAL( in_PREDICT_DIR_DIRECTION              ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_RAS_VAL                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_RAS_ACK                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_RAS_CONTEXT_ID             ,_param->_nb_inst_predict,_param->_size_context_id);
        DELETE1_SIGNAL( in_PREDICT_RAS_HIT                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_RAS_PUSH                   ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_RAS_ADDRESS_PUSH           ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL( in_PREDICT_RAS_ADDRESS_POP            ,_param->_nb_inst_predict,_param->_size_address);
//      DELETE1_SIGNAL( in_PREDICT_RAS_INDEX                  ,_param->_nb_inst_predict,_param->_size_ras_index);
        DELETE1_SIGNAL(out_PREDICT_UPT_VAL                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_UPT_ACK                    ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_UPT_CONTEXT_ID             ,_param->_nb_inst_predict,_param->_size_context_id);
        DELETE1_SIGNAL(out_PREDICT_UPT_BTB_ADDRESS_SRC        ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL(out_PREDICT_UPT_BTB_ADDRESS_DEST       ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL(out_PREDICT_UPT_BTB_CONDITION          ,_param->_nb_inst_predict,_param->_size_branch_condition);
        DELETE1_SIGNAL(out_PREDICT_UPT_BTB_LAST_TAKE          ,_param->_nb_inst_predict,1);
	DELETE1_SIGNAL(out_PREDICT_UPT_BTB_IS_ACCURATE        ,_param->_nb_inst_predict,1);
//      DELETE1_SIGNAL(out_PREDICT_UPT_DIR_HISTORY            ,_param->_nb_inst_predict,_param->_size_history);
        DELETE1_SIGNAL(out_PREDICT_UPT_RAS_ADDRESS            ,_param->_nb_inst_predict,_param->_size_address);
//      DELETE1_SIGNAL(out_PREDICT_UPT_RAS_INDEX              ,_param->_nb_inst_predict,_param->_size_ras_index);

	// ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
	DELETE1_SIGNAL( in_DEPTH_UPT_NB_BRANCH,_param->_nb_context,_param->_size_depth[alloc_signal_it1]);
	DELETE1_SIGNAL( in_DEPTH_UPT_TAIL     ,_param->_nb_context,_param->_size_depth[alloc_signal_it1]);
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
