/*
 * $Id: Parameters_msg_error.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace load_store_pointer_unit {


#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::msg_error"
  std::string Parameters::msg_error(void)
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

    std::string msg = "";

    for (uint32_t i=0; i<_nb_load_store_queue; i++)
      {
	if (not (_size_store_queue [i] > 1))
	  msg += "  - The size of store_queue["+toString(i)+"] must be greater or equal at 2.\n";
	if (not (_size_load_queue  [i] > 0))
	  msg += "  - The size of load_queue["+toString(i)+"] must be greater or equal at 1.\n";
      }

    bool map_lsq [_nb_load_store_queue];
    for (uint32_t i=0; i<_nb_load_store_queue; i++)
      map_lsq [i] = false;
    for (uint32_t i=0; i<_nb_front_end; i++)
      for (uint32_t j=0; j<_nb_context[i]; j++)
	if (_link_load_store_unit_with_thread[i][j] < _nb_load_store_queue)
	  map_lsq [_link_load_store_unit_with_thread[i][j]] = true;
	else
	  msg += "  - The number of load_store_unit for the thread ["+toString(i)+"]["+toString(j)+"] is too high.\n";
	  
    for (uint32_t i=0; i<_nb_load_store_queue; i++)
      if (map_lsq [i] == false)
	msg += "  - The load store unit ["+toString(i)+"] is not linked with a thread.\n";
    
    return msg;

    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };

}; // end namespace load_store_pointer_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
