#ifndef morpheo_behavioural_generic_registerfile_registerfile_multi_banked_Type_h
#define morpheo_behavioural_generic_registerfile_registerfile_multi_banked_Type_h

/*
 * $Id: Types.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Common/include/ToString.h"
#include "Common/include/FromString.h"
namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {

  typedef uint32_t Taddress_t;
  typedef uint32_t Tdata_t;

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic
}; // end namespace behavioural

  typedef enum {PARTIAL_CROSSBAR,
		FULL_CROSSBAR   } Tcrossbar_t;

  template<> inline Tcrossbar_t fromString<Tcrossbar_t> (const std::string& x)
  {
    if ( (x.compare("0")                == 0) or
	 (x.compare("PARTIAL_CROSSBAR") == 0))
      return PARTIAL_CROSSBAR;
    if ( (x.compare("1")                == 0) or
	 (x.compare("FULL_CROSSBAR"   ) == 0))
      return FULL_CROSSBAR;

    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };
  
  template<> inline std::string toString<Tcrossbar_t>   (const Tcrossbar_t& x)
  {
    std::ostringstream out;

    if (x == PARTIAL_CROSSBAR)
      out << "PARTIAL_CROSSBAR";
    if (x == FULL_CROSSBAR)
      out << "FULL_CROSSBAR";

    return out.str();
  };


}; // end namespace morpheo              

#endif
