/*
 * $Id: New_Component.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/@DIRECTORY/include/@COMPONENT.h"

namespace morpheo                    {
namespace behavioural {
@NAMESPACE_BEGIN

#undef  FUNCTION
#define FUNCTION "@COMPONENT::@COMPONENT"
  @COMPONENT::@COMPONENT 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::@NAMESPACE_USE::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,@COMPONENT,FUNCTION,"Begin");

    usage_environment(_usage);

    log_printf(INFO,@COMPONENT,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,@COMPONENT,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,@COMPONENT,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,@COMPONENT,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,@COMPONENT,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "@COMPONENT::~@COMPONENT"
  @COMPONENT::~@COMPONENT (void)
  {
    log_printf(FUNC,@COMPONENT,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,@COMPONENT,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,@COMPONENT,FUNCTION,"End");
  };

@NAMESPACE_END
}; // end namespace behavioural
}; // end namespace morpheo              
