#ifdef STATISTICS
#include "Behavioural/include/Stat.h"

namespace morpheo {
namespace behavioural {  

  std::string Stat::print (uint32_t depth)
  {
    end_simulation(); 

    cycle_t _cycle_sum = sc_simulation_time();

    morpheo::behavioural::XML xml (_name_instance);

    xml.balise_open_begin(_name_component);
    xml.attribut("name",_name_instance);
    xml.balise_open_end();

    // Print component
    for (std::list<Stat *>::iterator stat=_list_stat->begin();
	 stat != _list_stat->end();
	 stat ++)
      xml.text((*stat)->print(1));
    

    // Test special case

    if (have_counter())
      {
	if (_cycle_sum < _nb_cycle_before_begin)
	  {
	    xml.comment(_("Number of cycle is less than the number minimal"));
	  }
	else
	  {
	    bool stop = false;
	    cycle_t nb_cycle_min;
	    cycle_t nb_cycle_max = _nb_cycle_before_begin-1;
	    for (cycle_t period=0; stop==false; period++)
	      {
		std::map<std::string, var_t>::iterator operand=_list_operand->begin();
		
		if (operand->second.save_counter.size()==0)
		  throw(ERRORMORPHEO("Stat::generate_file",_("Queue 'save_counter' is empty.")));
		
		bool last = operand->second.save_counter.size()==1;
		
		nb_cycle_min  = nb_cycle_max+1;
		
		if (last)
		  nb_cycle_max = static_cast<cycle_t>(_cycle_sum);
		else
		  nb_cycle_max += _period;

		xml.balise_open_begin("period");
		xml.attribut("number",toString(period));
		xml.attribut("nb_cycle_min",toString(nb_cycle_min));
		xml.attribut("nb_cycle_max",toString(nb_cycle_max));
		xml.balise_open_end();
		
		for (;
		     operand!= _list_operand->end();
		     ++operand)
		  {
		    if (operand->second.type == TYPE_COUNTER)
		      {
			xml.singleton_begin(operand->second.name);
			xml.attribut("value",toString(operand->second.save_counter.front()));
			xml.attribut("unit",operand->second.unit);
			xml.attribut("description",operand->second.description);
			xml.singleton_end();
		      }
		    operand->second.save_counter.pop_front();
		  }
		
		xml.balise_close();
		
		stop = last;
	      }
	  }
      }
    xml.balise_close();

    return xml.get_body(depth);
  }
};  
};
#endif
